package org.jeecg.modules.iost.basedata.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @Description: delivery note
 * @Author: jeecg-boot
 * @Date:   2020-12-29
 * @Version: V1.0
 */
@ApiModel(value="iost_delivery_record对象", description="出库记录")
@Data
@TableName("iost_delivery_record")
public class IostDeliveryRecord4Pics implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private java.lang.String id;

	/**送货单图片*/
	@Excel(name = "送货单图片", width = 15)
    private transient java.lang.String deliveryRecordPicsString;

    private byte[] deliveryRecordPics;

    public byte[] getDeliveryRecordPics(){
        if(deliveryRecordPicsString==null){
            return null;
        }
        try {
            return deliveryRecordPicsString.getBytes("UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getDeliveryRecordPicsString(){
        if(deliveryRecordPics==null || deliveryRecordPics.length==0){
            return "";
        }
        try {
            return new String(deliveryRecordPics,"UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return "";
    }
}
