package org.jeecg.modules.iost.basedata.entity;

import java.io.Serializable;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @Description: 库存记录
 * @Author: jeecg-boot
 * @Date:   2020-11-10
 * @Version: V1.0
 */
@ApiModel(value="iost_inventory_record对象", description="库存记录")
@Data
@TableName("iost_inventory_record")
public class IostInventoryRecord implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private java.lang.String id;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private java.lang.String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private java.util.Date createTime;
	/**更新人*/
    @ApiModelProperty(value = "更新人")
    private java.lang.String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private java.util.Date updateTime;
	/**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private java.lang.String sysOrgCode;
	/**仓库名称*/
	@Excel(name = "仓库名称", width = 15, dictTable = "iost_storage", dicText = "name", dicCode = "id")
    @Dict(dictTable = "iost_storage", dicText = "name", dicCode = "id")
    @ApiModelProperty(value = "仓库名称")
    private java.lang.String warehouseName;
	/**总件数*/
	@Excel(name = "总件数", width = 15)
    @ApiModelProperty(value = "总件数")
    private java.lang.Integer CasesTotal;
}
