package org.jeecg.modules.iost.basedata.entity;

import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @Description: 入仓列表
 * @Author: jeecg-boot
 * @Date:   2020-12-17
 * @Version: V1.0
 */
@ApiModel(value="iost_receiving对象", description="入仓单")
@Data
@TableName("iost_receivinglist")
public class IostReceivinglist implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
	@ApiModelProperty(value = "主键")
	private java.lang.String id;
	/**创建人*/
	@ApiModelProperty(value = "创建人")
	private java.lang.String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "创建日期")
	private java.util.Date createTime;
	/**更新人*/
	@ApiModelProperty(value = "更新人")
	private java.lang.String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "更新日期")
	private java.util.Date updateTime;
	/**所属部门*/
	@ApiModelProperty(value = "所属部门")
	private java.lang.String sysOrgCode;
	/**商品中文名称*/
	@Excel(name = "商品中文名称", width = 15)
	@ApiModelProperty(value = "商品中文名称")
	private java.lang.String nameChs;
	/**商品类别*/
	@Excel(name = "商品类别", width = 15, dictTable = "iost_kind", dicText = "name", dicCode = "code")
	@ApiModelProperty(value = "商品类别")
	private java.lang.String kind;
	/**商品英文名称*/
	@Excel(name = "商品英文名称", width = 15)
	@ApiModelProperty(value = "商品英文名称")
	private java.lang.String nameEng;
	/**图片*/
	@Excel(name = "图片", width = 15)
	@ApiModelProperty(value = "图片")
	private java.lang.String picture;
	/**备注*/
	@Excel(name = "备注", width = 15)
	@ApiModelProperty(value = "备注")
	private java.lang.String note;
	/**商品描述*/
	@Excel(name = "商品描述", width = 15)
	@ApiModelProperty(value = "商品描述")
	private java.lang.String description;
	/**单位*/
	@Excel(name = "单位", width = 15)
	@ApiModelProperty(value = "单位")
	private java.lang.String unit;
	/**件数*/
	@Excel(name = "件数", width = 15)
	@ApiModelProperty(value = "件数")
	private java.lang.Integer cases;
	/**单件装箱数*/
	@Excel(name = "单件装箱数", width = 15)
	@ApiModelProperty(value = "单件装箱数")
	private java.lang.Integer packages;
	/**总装箱数*/
	@Excel(name = "总装箱数", width = 15)
	@ApiModelProperty(value = "总装箱数")
	private java.lang.Integer packagesTotal;
	/**长*/
	@Excel(name = "长", width = 15)
	@ApiModelProperty(value = "长")
	private java.lang.Integer length;
	/**宽*/
	@Excel(name = "宽", width = 15)
	@ApiModelProperty(value = "宽")
	private java.lang.Integer width;
	/**高*/
	@Excel(name = "高", width = 15)
	@ApiModelProperty(value = "高")
	private java.lang.Integer height;
	/**单件体积*/
	@Excel(name = "单件体积", width = 15)
	@ApiModelProperty(value = "单件体积")
	private java.lang.Double volume;
	/**总体积*/
	@Excel(name = "总体积", width = 15)
	@ApiModelProperty(value = "总体积")
	private java.lang.Double volumeTotal;
	/**单件箱重*/
	@Excel(name = "单件箱重", width = 15)
	@ApiModelProperty(value = "单件箱重")
	private java.lang.Double weight;
	/**总重量*/
	@Excel(name = "总重量", width = 15)
	@ApiModelProperty(value = "总重量")
	private java.lang.Double weightTotal;
	/**材质*/
	@Excel(name = "材质", width = 15)
	@ApiModelProperty(value = "材质")
	private java.lang.String material;
	/**单价*/
	@Excel(name = "单价", width = 15)
	@ApiModelProperty(value = "单价")
	private java.lang.Double price;
	/**金额*/
	@Excel(name = "金额", width = 15)
	@ApiModelProperty(value = "金额")
	private java.lang.Double money;
	/**入仓id*/
	@ApiModelProperty(value = "入仓id")
	private java.lang.String receivingId;
	/**关联件数*/
	@Excel(name = "关联件数", width = 15)
	@ApiModelProperty(value = "关联件数")
	private java.lang.Integer refCases;
	/**组装标示*/
	@Excel(name = "组装标示", width = 15)
	@ApiModelProperty(value = "组装标示")
	private java.lang.Integer packageFlag;
}
