package org.jeecg.modules.iost.basedata.mapper;

import java.util.List;

import org.jeecg.modules.iost.basedata.entity.DeliverySumSourceField;
import org.jeecg.modules.iost.basedata.entity.IostDeliveryRecordList;
import org.jeecg.modules.iost.basedata.entity.IostSummarySheetList;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

/**
 * @Description: 出库记录表
 * @Author: jeecg-boot
 * @Date:   2020-12-07
 * @Version: V1.0
 */
public interface IostDeliveryRecordListMapper extends BaseMapper<IostDeliveryRecordList> {

	public boolean deleteByMainId(@Param("mainId") String mainId);
    
	public List<IostDeliveryRecordList> selectByMainId(@Param("mainId") String mainId);
	
	public List<DeliverySumSourceField> getSumSourceFields(@Param("sourceEntryIds") List<String> sourceEntryIds);
	
	public List<IostSummarySheetList> getSummaryLists(@Param("mainId") String mainId);
}
