package org.jeecg.modules.iost.basedata.service.impl;

import org.jeecg.modules.iost.basedata.entity.IostCustomer;
import org.jeecg.modules.iost.basedata.entity.IostCustomerlist;
import org.jeecg.modules.iost.basedata.mapper.IostCustomerlistMapper;
import org.jeecg.modules.iost.basedata.mapper.IostCustomerMapper;
import org.jeecg.modules.iost.basedata.service.IIostCustomerService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import java.io.Serializable;
import java.util.List;
import java.util.Collection;

/**
 * @Description: 客户管理
 * @Author: jeecg-boot
 * @Date:   2020-12-15
 * @Version: V1.0
 */
@Service
public class IostCustomerServiceImpl extends ServiceImpl<IostCustomerMapper, IostCustomer> implements IIostCustomerService {

	@Autowired
	private IostCustomerMapper iostCustomerMapper;
	@Autowired
	private IostCustomerlistMapper iostCustomerlistMapper;
	
	@Override
	@Transactional
	public void saveMain(IostCustomer iostCustomer, List<IostCustomerlist> iostCustomerlistList) {
		iostCustomerMapper.insert(iostCustomer);
		if(iostCustomerlistList!=null && iostCustomerlistList.size()>0) {
			for(IostCustomerlist entity:iostCustomerlistList) {
				//外键设置
				entity.setCustomerId(iostCustomer.getId());
				iostCustomerlistMapper.insert(entity);
			}
		}
	}

	@Override
	@Transactional
	public void updateMain(IostCustomer iostCustomer,List<IostCustomerlist> iostCustomerlistList) {
		iostCustomerMapper.updateById(iostCustomer);
		
		//1.先删除子表数据
		iostCustomerlistMapper.deleteByMainId(iostCustomer.getId());
		
		//2.子表数据重新插入
		if(iostCustomerlistList!=null && iostCustomerlistList.size()>0) {
			for(IostCustomerlist entity:iostCustomerlistList) {
				//外键设置
				entity.setCustomerId(iostCustomer.getId());
				iostCustomerlistMapper.insert(entity);
			}
		}
	}

	@Override
	@Transactional
	public void delMain(String id) {
		iostCustomerlistMapper.deleteByMainId(id);
		iostCustomerMapper.deleteById(id);
	}

	@Override
	@Transactional
	public void delBatchMain(Collection<? extends Serializable> idList) {
		for(Serializable id:idList) {
			iostCustomerlistMapper.deleteByMainId(id.toString());
			iostCustomerMapper.deleteById(id);
		}
	}
	
}
