package org.jeecg.modules.iost.basedata.service.impl;

import org.jeecg.modules.iost.basedata.entity.IostDeliveryRecord;
import org.jeecg.modules.iost.basedata.entity.IostDeliveryRecordList;
import org.jeecg.modules.iost.basedata.mapper.IostDeliveryRecordListMapper;
import org.jeecg.modules.iost.basedata.mapper.IostDeliveryRecordMapper;
import org.jeecg.modules.iost.basedata.service.IIostDeliveryRecordService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import java.io.Serializable;
import java.util.List;
import java.util.Collection;

/**
 * @Description: 出库记录
 * @Author: jeecg-boot
 * @Date:   2020-12-07
 * @Version: V1.0
 */
@Service
public class IostDeliveryRecordServiceImpl extends ServiceImpl<IostDeliveryRecordMapper, IostDeliveryRecord> implements IIostDeliveryRecordService {

	@Autowired
	private IostDeliveryRecordMapper iostDeliveryRecordMapper;
	@Autowired
	private IostDeliveryRecordListMapper iostDeliveryRecordListMapper;
	
	@Override
	@Transactional
	public void saveMain(IostDeliveryRecord iostDeliveryRecord, List<IostDeliveryRecordList> iostDeliveryRecordListList) {
		iostDeliveryRecordMapper.insert(iostDeliveryRecord);
		if(iostDeliveryRecordListList!=null && iostDeliveryRecordListList.size()>0) {
			for(IostDeliveryRecordList entity:iostDeliveryRecordListList) {
				//外键设置
				entity.setDeliveryRecordId(iostDeliveryRecord.getId());
				iostDeliveryRecordListMapper.insert(entity);
			}
		}
	}

	@Override
	@Transactional
	public void updateMain(IostDeliveryRecord iostDeliveryRecord,List<IostDeliveryRecordList> iostDeliveryRecordListList) {
		iostDeliveryRecordMapper.updateById(iostDeliveryRecord);
		
		//1.先删除子表数据
		iostDeliveryRecordListMapper.deleteByMainId(iostDeliveryRecord.getId());
		
		//2.子表数据重新插入
		if(iostDeliveryRecordListList!=null && iostDeliveryRecordListList.size()>0) {
			for(IostDeliveryRecordList entity:iostDeliveryRecordListList) {
				//外键设置
				entity.setDeliveryRecordId(iostDeliveryRecord.getId());
				iostDeliveryRecordListMapper.insert(entity);
			}
		}
	}

	@Override
	@Transactional
	public void delMain(String id) {
		iostDeliveryRecordListMapper.deleteByMainId(id);
		iostDeliveryRecordMapper.deleteById(id);
	}

	@Override
	@Transactional
	public void delBatchMain(Collection<? extends Serializable> idList) {
		for(Serializable id:idList) {
			iostDeliveryRecordListMapper.deleteByMainId(id.toString());
			iostDeliveryRecordMapper.deleteById(id);
		}
	}
	
}
