package org.jeecg.modules.iost.basedata.service.impl;

import org.jeecg.modules.iost.basedata.entity.IostInsurancePolicy;
import org.jeecg.modules.iost.basedata.entity.IostInsurancePolicyList;
import org.jeecg.modules.iost.basedata.mapper.IostInsurancePolicyListMapper;
import org.jeecg.modules.iost.basedata.mapper.IostInsurancePolicyMapper;
import org.jeecg.modules.iost.basedata.service.IIostInsurancePolicyService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import java.io.Serializable;
import java.util.List;
import java.util.Collection;

/**
 * @Description: 保险单
 * @Author: jeecg-boot
 * @Date:   2020-11-20
 * @Version: V1.0
 */
@Service
public class IostInsurancePolicyServiceImpl extends ServiceImpl<IostInsurancePolicyMapper, IostInsurancePolicy> implements IIostInsurancePolicyService {

	@Autowired
	private IostInsurancePolicyMapper iostInsurancePolicyMapper;
	@Autowired
	private IostInsurancePolicyListMapper iostInsurancePolicyListMapper;
	
	@Override
	@Transactional
	public void saveMain(IostInsurancePolicy iostInsurancePolicy, List<IostInsurancePolicyList> iostInsurancePolicyListList) {
		iostInsurancePolicyMapper.insert(iostInsurancePolicy);
		if(iostInsurancePolicyListList!=null && iostInsurancePolicyListList.size()>0) {
			for(IostInsurancePolicyList entity:iostInsurancePolicyListList) {
				//外键设置
				entity.setInsurancePolicyId(iostInsurancePolicy.getId());
				iostInsurancePolicyListMapper.insert(entity);
			}
		}
	}

	@Override
	@Transactional
	public void updateMain(IostInsurancePolicy iostInsurancePolicy,List<IostInsurancePolicyList> iostInsurancePolicyListList) {
		iostInsurancePolicyMapper.updateById(iostInsurancePolicy);
		
		//1.先删除子表数据
		iostInsurancePolicyListMapper.deleteByMainId(iostInsurancePolicy.getId());
		
		//2.子表数据重新插入
		if(iostInsurancePolicyListList!=null && iostInsurancePolicyListList.size()>0) {
			for(IostInsurancePolicyList entity:iostInsurancePolicyListList) {
				//外键设置
				entity.setInsurancePolicyId(iostInsurancePolicy.getId());
				iostInsurancePolicyListMapper.insert(entity);
			}
		}
	}

	@Override
	@Transactional
	public void delMain(String id) {
		iostInsurancePolicyListMapper.deleteByMainId(id);
		iostInsurancePolicyMapper.deleteById(id);
	}

	@Override
	@Transactional
	public void delBatchMain(Collection<? extends Serializable> idList) {
		for(Serializable id:idList) {
			iostInsurancePolicyListMapper.deleteByMainId(id.toString());
			iostInsurancePolicyMapper.deleteById(id);
		}
	}
	
}
