package org.jeecg.modules.iost.basedata.service.impl;

import org.jeecg.modules.iost.basedata.entity.IostReceivingNote;
import org.jeecg.modules.iost.basedata.entity.IostReceivingNoteList;
import org.jeecg.modules.iost.basedata.mapper.IostReceivingNoteListMapper;
import org.jeecg.modules.iost.basedata.mapper.IostReceivingNoteMapper;
import org.jeecg.modules.iost.basedata.service.IIostReceivingNoteService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import java.io.Serializable;
import java.util.List;
import java.util.Collection;

/**
 * @Description: 收费单
 * @Author: jeecg-boot
 * @Date:   2020-12-22
 * @Version: V1.0
 */
@Service
public class IostReceivingNoteServiceImpl extends ServiceImpl<IostReceivingNoteMapper, IostReceivingNote> implements IIostReceivingNoteService {

	@Autowired
	private IostReceivingNoteMapper iostReceivingNoteMapper;
	@Autowired
	private IostReceivingNoteListMapper iostReceivingNoteListMapper;
	
	@Override
	@Transactional
	public void saveMain(IostReceivingNote iostReceivingNote, List<IostReceivingNoteList> iostReceivingNoteListList) {
		iostReceivingNoteMapper.insert(iostReceivingNote);
		if(iostReceivingNoteListList!=null && iostReceivingNoteListList.size()>0) {
			for(IostReceivingNoteList entity:iostReceivingNoteListList) {
				//外键设置
				entity.setReceivingNoteId(iostReceivingNote.getId());
				iostReceivingNoteListMapper.insert(entity);
			}
		}
	}

	@Override
	@Transactional
	public void updateMain(IostReceivingNote iostReceivingNote,List<IostReceivingNoteList> iostReceivingNoteListList) {
		iostReceivingNoteMapper.updateById(iostReceivingNote);
		
		//1.先删除子表数据
		iostReceivingNoteListMapper.deleteByMainId(iostReceivingNote.getId());
		
		//2.子表数据重新插入
		if(iostReceivingNoteListList!=null && iostReceivingNoteListList.size()>0) {
			for(IostReceivingNoteList entity:iostReceivingNoteListList) {
				//外键设置
				entity.setReceivingNoteId(iostReceivingNote.getId());
				iostReceivingNoteListMapper.insert(entity);
			}
		}
	}

	@Override
	@Transactional
	public void delMain(String id) {
		iostReceivingNoteListMapper.deleteByMainId(id);
		iostReceivingNoteMapper.deleteById(id);
	}

	@Override
	@Transactional
	public void delBatchMain(Collection<? extends Serializable> idList) {
		for(Serializable id:idList) {
			iostReceivingNoteListMapper.deleteByMainId(id.toString());
			iostReceivingNoteMapper.deleteById(id);
		}
	}


}
