package org.jeecg;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import kingdee.bos.webapi.client.K3CloudApiClient;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.jeecg.common.util.security.SecurityTools;
import org.jeecg.common.util.security.entity.*;
import org.jeecg.modules.iost.API.ExternalInterface.LoanInterfaceApi;
import org.jeecg.modules.iost.API.Util.HttpUtils;
import org.jeecg.modules.iost.API.Util.JsonUtil;
import org.jeecg.modules.iost.API.Util.OAUtil;
import org.jeecg.modules.iost.API.entity.LQKJ_t_IMSSyncDetails;
import org.jeecg.modules.iost.API.vo.OaRequest;
import org.jeecg.modules.iost.API.webapi.LQKJ_t_IMSSyncDetailsWebapi;
import org.jeecg.modules.iost.API.webapi.LoanInterfaceWebapi;
import org.jeecg.modules.iost.API.webapi.SALorderWebapi;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableScheduling;


import java.util.*;

@Slf4j
@EnableScheduling
public class SecurityToolsTest {
    //    static String K3CloudURL = "http://cwxt.kingsware.cn/k3cloud/";//指定地址
//    static String dbId = "6136b7c51f0e4f";
//    static String uid = "Administrator";
//    static String pwd = "888888";
//    static int lang = 2052;
    static String K3CloudURL = "http://192.168.2.190/k3cloud/";//指定地址
    static String dbId = "61a5ffe08bb8ba";
    static String uid = "lt";
    static String pwd = "666666";
    static int lang = 2052;
    K3CloudApiClient client = new K3CloudApiClient(K3CloudURL);

//    @Test
    public void Test() {
        MyKeyPair mkeyPair = SecurityTools.generateKeyPair();

        JSONObject msg = new JSONObject();
        msg.put("name", "党政辉");
        msg.put("age", 50);
        JSONObject identity = new JSONObject();
        identity.put("type", "01");
        identity.put("no", "210882165896524512");
        msg.put("identity", identity);

        // 签名加密部分
        SecuritySignReq signReq = new SecuritySignReq();
        // data为要加密的报文字符串
        signReq.setData(msg.toString());
        // 为rsa私钥
        signReq.setPrikey(mkeyPair.getPriKey());
        // 调用签名方法
        SecuritySignResp sign = SecurityTools.sign(signReq);
        // 打印出来加密数据
        // signData为签名数据
        // data为aes加密数据
        // asekey为ras加密过的aeskey
        //System.out.println(new JSONObject(sign).toStringPretty());

        // 验签解密部分
        SecurityReq req = new SecurityReq();
        //对方传过来的数据一一对应
        req.setAesKey(sign.getAesKey());
        req.setData(sign.getData());
        req.setSignData(sign.getSignData());
        //我们的公钥
        req.setPubKey(mkeyPair.getPubKey());
        //验签方法调用
        SecurityResp securityResp = SecurityTools.valid(req);
        //解密报文data为解密报文
        //sucess 为验签成功失败标志 true代码验签成功，false代表失败
        // System.out.println(new JSONObject(securityResp).toStringPretty());
    }

//    @Test
    public void request() {
        List<Map<String, Object>> lists = new ArrayList<Map<String, Object>>();
        String url = "http://192.168.1.19:8080/wmssystem/API/eip-prod-store/list";
        Map<String, String> hreader = new HashMap<>();
        hreader.put("operatetype", "add");
        hreader.put("transno", "201910086843218<Az2eV3>");
        hreader.put("orisys", "0");
        hreader.put("X-Access-Token", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJleHAiOjE2MjY0MDkyMDAsInVzZXJuYW1lIjoiYWRtaW4ifQ.bERvQx5MmxZdtwcM6NqI9yng95EPmhF9OgtUBBIyOqs");
        String result = HttpUtils.getRequest(url, hreader, null);
        S(result);
    }

    public static JSONObject S(String data) {
        JSONObject jsonObject = JSONObject.fromObject(data);
        System.out.println(jsonObject.get("data"));
        log.info(jsonObject.get(data).toString());
        return jsonObject;
    }

//    @Test
    public void S() {
        Random r = new Random();

        // 第一种方法
//            int num = (int) (Math.random() * 5 + 1);
//            System.out.println("num:" + num);
        // 第二种方法
        int a = r.nextInt(5) + 1;
        System.out.println("a:" + a);

    }
    static String sFormId = "k2d1839c385a04b62983eb4183c4745fd";
    public List sFormId(Map<String,K3CloudApiClient> clientMap) {

        org.jeecg.Test test = new org.jeecg.Test();

        List list = test.checkFiled(sFormId, new HashMap() {{
            put("fnumber", "fnumber");
        }}, new HashMap() {{
            put("fnumber", "'XXDD202105200009'");
        }}, clientMap);
        System.out.println("1"+list);
        System.out.println("1"+clientMap);
        return list;
    }
    /**
     * 测试定时
     */
    @Test
//    @Scheduled(fixedDelay = 5000)
    public void timed() {
        String servicenameTable = "LQKJ.WebApi.Stub.CustomWebApiService.ExecutDataSet,LQKJ.WebApi.Stub";
        String servicenameMap = "LQKJ.WebApi.Stub.CustomWebApiService.ExecuteDynamicObject,LQKJ.WebApi.Stub";
        log.info("123");
        List<List<Object>> list = null;
        try {
            Boolean result = client.login(dbId, uid, pwd, lang);
            if (result) {
                String sql ="SELECT * FROM t_ER_ExpenseReimb where FID in ('100103')";
//                String sql = "SELECT * FROM LQKJ_t_IMSSync where F_LQKJ_SyncCheck = 0;";
                System.out.println(sql);
                String[] strings = new String[]{sql};
//                List execute = client.execute(servicenameMap, strings, List.class);

                List execute = client.execute(servicenameMap, strings, List.class);

                System.out.println("dsads"+execute);
//                for (Object o : execute) {
//                    System.out.println(execute);
//                }
//                if (null == execute) {
//                    System.out.println("你好");
//                } else {
//                    System.out.println("你好2");
//                }
//                System.out.println(execute.size());
//                for (Map o : execute) {
//                    System.out.println(o.get("F_LQKJ_SYNCCHECK"));
//                }


            }
        } catch (Exception e) {
            System.out.println("nb");
            e.printStackTrace();
        }
        System.out.println("end");
    }

//    @Autowired
//    LoanInterfaceWebapi loanInterfaceWebapi;

//    @Test
//    @Scheduled(fixedDelay = 5000)
    public void timdsaded() throws InterruptedException {
        LoanInterfaceApi queryLoanDetailsApi = new LoanInterfaceApi();
        Map params = new LinkedHashMap() {{
            put("method", "discardWorknumber");
            put("worknumber", "1");
            put("status", "已付款");
        }};
        String select = queryLoanDetailsApi.select();
        System.out.println(select);
        OaRequest<List<Map>> listOaRequest = com.alibaba.fastjson.JSONObject.parseObject(select, OaRequest.class);
//        List<Map> result = listOaRequest.getResult();
//        new ToolsTest().Async();
        System.out.println(listOaRequest.getResult());
//        loanInterfaceWebapi.add(listOaRequest.getResult().get(0));
//        System.out.println(result.get(0).size());

    }

//    @Async
    public void dassdadsdads() throws InterruptedException {
        Thread.sleep(50000);
        System.out.println("nkklkjnlkkkkkkk");
    }

    @Autowired
    private LQKJ_t_IMSSyncDetailsWebapi webapi;

//    @Test
//    @Scheduled(fixedDelay = 5000)
    public void sadsad() {
        List<Map> objects = new ArrayList<>();
        LinkedHashMap a = new LinkedHashMap() {{
            put("aurfgd", 1);
            put("bjkuy", "b");
            put("cfdsafda", "c");
        }};
        LinkedHashMap b = new LinkedHashMap() {{
            put("bjkuy", "b");
        }};
        LinkedHashMap c = new LinkedHashMap() {{
            put("cfdsafda", "c");
        }};
        objects.add(a);
//        objects.add(b);
//        objects.add(c);
        String listjson = JsonUtil.Listjson(objects);
        System.out.println(listjson);
//        "[{"aurfgd":"a", "bjkuy":"b", "cfdsafda":"c"}]"

    }


    @Test
    public void StringCompareIn() {
//        {"fid":"123","f_lqkj_syncdataid":"sda","f_lqkj_syncbill":"123","f_lqkj_synccheck":"123"}

        String a = "{FID=e08040bc-7719-43d9-9865-8458a324415b, F_LQKJ_SYNCDATAID=100008, F_LQKJ_SYNCBILL=PUR_Requisition, F_LQKJ_SYNCCHECK=0}";
        Map map = new HashMap();
        map.put("FID", "e08040bc");
        map.put("F_LQKJ_SYNCDATAID", "100008");
//        map.put("F_Lqkj_Syncdataid", "100009");
        map.put("F_LQKJ_SYNCBILL", "PUR_Requisition");
        map.put("F_LQKJ_SYNCCHECK", "0");
        map.put("FID", "123456");
        String o = "[{\"fid\":\"123\",\"f_lqkj_syncdataid\":\"sda\",\"f_lqkj_syncbill\":\"123\",\"f_lqkj_synccheck\":\"123\",\"F_QPOV_BasE\":{\"FName\":\"QJFYQC001\"}}]";
        String filter = filter(o);
        System.out.println(filter);
//        LQKJ_t_IMSSyncDetails lqkj_t_imsSync = JSON.parseObject(JSON.toJSONString(map), LQKJ_t_IMSSyncDetails.class).setCreatetime(new Date());
//        System.out.println(lqkj_t_imsSync);
    }
     public String filter(String s) {//过滤掉不包含F_QPOV_Base字段的数据，并返回展示
//        那个默认值的代码是：XXDD202105200009，名称是：QJFYQC001
        Map QJFYQC001 = new HashMap<>();
        QJFYQC001.put("FName", "QJFYQC001");
        List list = JSON.parseObject(s, List.class, Feature.OrderedField);
        List<Map> returnResults = new ArrayList<Map>();
        Map<String,K3CloudApiClient> clientMap = new HashMap() {{
            put("clientTwo", null);
        }};
        for (Object linkedHashMap : list) {
            Map map = JSON.parseObject(linkedHashMap.toString(), LinkedHashMap.class);
            QPOV_Base pojo = JSON.parseObject(linkedHashMap.toString(), QPOV_Base.class);
            System.out.println("QPOV_Base"+pojo);
            if (map.containsKey("F_QPOV_Base")) {
                if (null != map.get("F_QPOV_Base")) {
                    Map F_QPOV_Base = JSON.parseObject(map.get("F_QPOV_Base").toString(), LinkedHashMap.class);
                    String fName = F_QPOV_Base.get("FName").toString();
                    returnResults.add(map);
                } else {
                    map.put("F_QPOV_Base", QJFYQC001);
                    returnResults.add(map);
                }
            } else {
                map.put("F_QPOV_Base", QJFYQC001);
                returnResults.add(map);
            }
        }
//        if (null != end && 0 < end.size()) returnResult.put("缺少立项号/合同号", JsonUtil.Listjson(end));

        return JsonUtil.Listjson(returnResults);
    }
}
