package com.santos.iost.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.santos.iost.common.CommonConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 *   接口返回数据格式
 * @author scott
 * @email jeecgos@163.com
 * @date  2019年1月19日
 */
@Data
@ApiModel(value="接口返回对象", description="接口返回对象")
public class Result<T> implements Serializable {

	private static final long serialVersionUID = 1L;



	 /**
	 * 返回代码
	 */
	@ApiModelProperty(value = "返回代码")
	private String code ;

	/**
	 * 返回处理消息
	 */
	@ApiModelProperty(value = "返回处理消息")
	private String message = "操作成功！";

	/**
	 * 返回数据对象 data
	 */
	@ApiModelProperty(value = "返回数据对象")
	private T data;

	/**
	 * 时间戳
	 */
//	@ApiModelProperty(value = "时间戳")
//	private long timestamp = System.currentTimeMillis();

	public Result() {

	}

	public Result<T> success(String message) {
		this.message = message;
		this.code = CommonConstant.SC_OK_200.toString();
		return this;
	}

	@Deprecated
	public static Result<Object> ok() {
		Result<Object> r = new Result<Object>();
		r.setCode(CommonConstant.SC_OK_200.toString());
		r.setMessage("成功");
		return r;
	}

	@Deprecated
	public static Result<Object> ok(String msg) {
		Result<Object> r = new Result<Object>();
		r.setCode(CommonConstant.SC_OK_200.toString());
		r.setMessage(msg);
		return r;
	}

	@Deprecated
	public static Result<Object> ok(Object data) {
		Result<Object> r = new Result<Object>();
		r.setCode(CommonConstant.SC_OK_200.toString());
		r.setData(data);
		return r;
	}

	public static<T> Result<T> OK() {
		Result<T> r = new Result<T>();
		r.setCode(CommonConstant.SC_OK_200.toString());
		r.setMessage("成功");
		return r;
	}

	public static<T> Result<T> OK(T data) {
		Result<T> r = new Result<T>();
		r.setCode(CommonConstant.SC_OK_200.toString());
		r.setData(data);
		return r;
	}

	public static<T> Result<T> OKMSG(String msg, T data) {
		Result<T> r = new Result<T>();
		r.setCode(CommonConstant.SC_OK_200.toString());
		r.setMessage(msg);
		r.setData(data);
		return r;
	}

	public static<T> Result<T> fail(String msg, T data,String Code) {
		Result<T> r = new Result<T>();
		r.setCode(Code);
		r.setMessage(msg);
		r.setData(data);
		return r;
	}
	public static<T> Result<T> OK(T data,String code) {
		Result<T> r = new Result<T>();
		r.setCode(code);
		r.setMessage("操作成功");
		r.setData(data);
		return r;
	}

	public static Result<Object> error(String msg) {
		return error(CommonConstant.SC_INTERNAL_SERVER_ERROR_500.toString(), msg);
	}

	public static Result<Object> error(String code, String msg) {
		Result<Object> r = new Result<Object>();
		r.setCode(code);
		r.setMessage(msg);
		return r;
	}

	public Result<T> error500(String message) {
		this.message = message;
		this.code = CommonConstant.SC_INTERNAL_SERVER_ERROR_500.toString();
		return this;
	}

	public Result<T> SoSsOk(String message) {
		this.message = message;
		this.code = CommonConstant.SC_INTERNAL_SERVER_ERROR_500.toString();
		return this;
	}

	/**
	 * 无权限访问返回结果
	 */
	public static Result<Object> noauth(String msg) {
		return error(CommonConstant.SC_JEECG_NO_AUTHZ.toString(), msg);
	}

	@JsonIgnore
	private String onlTable;

}