package com.santos.iost.controller;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.santos.iost.dao.SoSsDao;
import com.santos.iost.dto.SoSsResponseDate;
import com.santos.iost.utils.HttpUtil;
import com.santos.iost.utils.JsonUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HeaderElement;
import org.apache.http.HeaderElementIterator;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HTTP;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.TextUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import java.text.SimpleDateFormat;
import java.util.*;

//
//@SpringBootTest
//@Slf4j
//@RunWith(SpringJUnit4ClassRunner.class)
//@EnableScheduling
@RestController
//@RequestMapping("/api")
@Slf4j
class JintaiDomeApplicationTests {
    String getTokenUrl = "http://123.58.109.39:86/K3API/Token/Create?authorityCode=606d25b51be50949e768241934225bc05bfd6db0bae63e82";
    String getGetMaterialUrl = "http://123.58.109.39:86/K3API/Material/GetList?token=";
    String includeDetailUrl = "http://123.58.109.39:86/K3API/SO/GetDetail?token=";
    String token;
    @Autowired
    SoSsDao soSsDao;

    public void sd() {
        ConnectionKeepAliveStrategy myStrategy = new ConnectionKeepAliveStrategy() {

            @Override
            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                HeaderElementIterator it = new BasicHeaderElementIterator
                        (response.headerIterator(HTTP.CONN_KEEP_ALIVE));
                while (it.hasNext()) {
                    HeaderElement he = it.nextElement();
                    String param = he.getName();
                    String value = he.getValue();
                    if (value != null && param.equalsIgnoreCase
                            ("timeout")) {
                        return Long.parseLong(value) * 1000;
                    }
                }
                return 60 * 1000;//如果没有约定，则默认定义时长为60s
            }
        };

        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(500);
        connectionManager.setDefaultMaxPerRoute(50);//例如默认每路由最高50并发，具体依据业务来定
        HttpClient httpClient = HttpClients.custom()
                .setConnectionManager(connectionManager)
                .setKeepAliveStrategy(myStrategy)
                .setDefaultRequestConfig(RequestConfig.custom().setStaleConnectionCheckEnabled(true).build())
                .build();
    }


    @GetMapping(value = "/test")
    String contextLoads() throws Exception {

        String s = HttpUtil.get(getTokenUrl);
        Map map = JSON.parseObject(s, Map.class);
        String D = map.get("Data").toString();
        Map mapDate = JSON.parseObject(D, Map.class);
        token = mapDate.get("Token").toString();
//        System.out.println(token);
        Map paramsMap = new HashMap();
        Map Data = new LinkedHashMap();
        Data.put("Top", "100");
        Data.put("PageSize", "17");
        Data.put("PageIndex", "1");
//        Data.put("Filter","FNumber like '%003%' ");
        Data.put("OrderBy", "FNumber asc");
        Data.put("Fields", "FNumber,FName,F_101,FUnitID,FSalePrice");
        paramsMap.put("Data", Data);

        Map<String, String> hreader = new HashMap<>();
        hreader.put("Content-Type", "application/json");

        String post = HttpUtil.post(getGetMaterialUrl + token, JsonUtil.Mapjson(paramsMap), hreader);
//        System.out.println(post);
        return post;
    }


}


