package com.santos.iost.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.santos.iost.dao.SoSsDao;
import com.santos.iost.dto.Result;
import com.santos.iost.dto.SoSsResponseDate;
import com.santos.iost.service.SoSsCustomerService;
import com.santos.iost.utils.JsonUtil;
import com.santos.iost.vo.SoSsCreateVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class SoSsCustomerServiceImpl implements SoSsCustomerService {

    @Autowired
    SoSsDao soSsDao;

    String Url;//拼接用请求地址-（http://127.0.0.1/K3API/Material/GetList?token=${token}）

    /**
     * 请求字段
     */
    String FNumber = "FNumber";//代码
    String FName = "FName";//名称
    String FAddress = "FAddress";//地址
    String FRegionID = "FRegionID";//区域
    String FContact = "FContact";//联系人
    String FPhone = "FPhone";//联系人电话
    String Femployee = "Femployee";//专营业务员


    public SoSsCustomerServiceImpl() {
        this.Url = "/K3API/Customer/Save";//拼接用请求地址-（http://127.0.0.1/K3API/Material/GetList?token=${token}）

    }

    @Override
    public Result setData(SoSsCreateVo soSsRequestVo) throws Exception {
        Map params = new HashMap<>();
        Map<Object, Object> Data = new LinkedHashMap<>();
        Map masterFieldVal = soSsRequestVo.getMasterFieldVal();
        Data.put(FNumber, masterFieldVal.get("ERPNumber"));
        Data.put(FName, masterFieldVal.get("customerName"));
        Data.put(FAddress, masterFieldVal.get("detailedAddress"));
        Data.put(FRegionID, new HashMap(){{put("FID",masterFieldVal.get("customerLevel"));}});//二级结构
        Data.put(FContact, masterFieldVal.get("contacts"));
        Data.put(FPhone, masterFieldVal.get("phone"));
        Data.put(Femployee, new HashMap(){{put("FNumber",masterFieldVal.get("personCharge"));}});//二级结构
        params.put("Data", Data);
        String s = soSsDao.setK3Api(Url, JsonUtil.Mapjson(params));

        SoSsResponseDate soSsResponseDate = JSON.parseObject(s, SoSsResponseDate.class, Feature.OrderedField);
        Result result = changeResponse(soSsResponseDate);//
        return result;
    }

    /*转换*/
    public Result changeResponse(SoSsResponseDate soSsRequestVo) {
        Map<Object, Object> map = new HashMap<>();
        Result result = new Result();

        //将ERP格式变换为CRM格式
        result.setMessage(soSsRequestVo.getMessage());
        result.setCode(soSsRequestVo.getStatusCode());
        result.setData(soSsRequestVo.getData());

        return result;
    }
}
