/*
 * Decompiled with CFR 0.152.
 */
package kingdee.bos.webapi.client;

import kingdee.bos.json.JSONObject;
import kingdee.bos.webapi.client.ApiHttpClient;
import kingdee.bos.webapi.client.ApiRequest;
import kingdee.bos.webapi.client.ApiServiceRequest;
import kingdee.bos.webapi.client.IAsyncActionCallBack;
import org.apache.http.client.CookieStore;

public class ApiClient {
    private String _serverUrl;
    private CookieStore _cookieStore;

    public ApiClient(String serverUrl) {
        this._serverUrl = serverUrl;
    }

    public <T> ApiRequest<T> createRequest(String servicename, Object[] parameters, Class<T> returnType) {
        return new ApiServiceRequest<T>(this._serverUrl, this._cookieStore, servicename, parameters, returnType);
    }

    public <T> T execute(String servicename, Object[] parameters, Class<T> returnType) throws Exception {
        ApiRequest request = this.createRequest(servicename, parameters, returnType);
        ApiHttpClient httpClient = new ApiHttpClient();
        request.setListener(httpClient);
        return httpClient.Send(request, returnType);
    }

    public <T> ApiRequest<T> executeAsync(String servicename, Object[] parameters, Class<T> returnType, IAsyncActionCallBack<T> callback) throws Exception {
        ApiRequest<T> request = this.createRequest(servicename, parameters, returnType);
        ApiHttpClient<T> httpClient = new ApiHttpClient<T>(callback);
        request.setListener(httpClient);
        httpClient.syncSend(request);
        return request;
    }

    public Boolean login(String dbId, String userName, String password, int lcid) throws Exception {
        try {
            Object[] loginInfo = new Object[]{dbId, userName, password, lcid};
            ApiRequest<String> request = this.createRequest("Kingdee.BOS.WebApi.ServicesStub.AuthService.ValidateUser", loginInfo, String.class);
            ApiHttpClient<String> httpClient = new ApiHttpClient<String>();
            request.setListener(httpClient);
            String ret = httpClient.Send(request, String.class);
            System.out.println(ret);
            int result = new JSONObject(ret).getInt("LoginResultType");
            if (result == 1) {
                this._cookieStore = request.getCookieStore();
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

