package com.santos.iost.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.santos.iost.dao.SoSsDao;
import com.santos.iost.dto.Result;
import com.santos.iost.dto.SoSsResponseDate;
import com.santos.iost.service.SoSsInventoryService;
import com.santos.iost.utils.JsonUtil;
import com.santos.iost.vo.SoSsRequestVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

//库存
@Service
public class SoSsInventoryServiceImpl implements SoSsInventoryService {
    @Autowired
    SoSsDao soSsDao;

    String Url;//拼接用请求地址-（http://127.0.0.1/K3API/Material/GetList?token=${token}）

    /**
     * 需求字段
     */
    String 物料代码 = "物料代码";
    String 物料名称 = "物料名称";
    String 批号 = "批号";
    String 仓库名称 = "仓库名称";
    String 基本单位数量 = "基本单位数量";

    public SoSsInventoryServiceImpl() {
        this.Url = "/K3API/SQLReport95/GetList";//拼接用请求地址-（http://127.0.0.1/K3API/Material/GetList?token=${token}）

    }

    @Override
    public Result getData(SoSsRequestVo soSsRequestVo) {

        String s = new String();
        Map map = changeGeta(soSsRequestVo);
        try {
            s = soSsDao.requestK3Api(Url, JsonUtil.Mapjson(map));
        } catch (Exception e) {
            e.printStackTrace();
        }

        SoSsResponseDate soSsResponseDate = JSON.parseObject(s, SoSsResponseDate.class, Feature.OrderedField);

        Result result = changeResponse(soSsResponseDate);//

        return result;
    }


    /*转换请求参数*/
    public Map changeGeta(SoSsRequestVo soSsRequestVo) {
        Map paramsMap = new HashMap();
        Map Data = new LinkedHashMap();
        Data.put("PageSize", soSsRequestVo.getLimit());//每页行数
        Data.put("PageIndex", soSsRequestVo.getOffset());//第几页
        paramsMap.put("Data", Data);
        return paramsMap;
    }

    //检查ERM日期是否可用作过滤条件
    boolean checkFilter(SoSsRequestVo soSsRequestVo) {
        if (null == soSsRequestVo.getStartTime() && null == soSsRequestVo.getEndTime()) {
            return false;
        }
        return true;
    }

    /*转换*/
    public Result changeResponse(SoSsResponseDate soSsRequestVo) {
        Map<Object, Object> map = new HashMap<>();
        Result result = new Result();

        try {//字段转换-变化soSsRequestVo的data参数格式 为CRM规定格式
            List dataList = new ArrayList<>();
            Map data = (Map) soSsRequestVo.getData();
            Object data1 = data.get("DATA");
            List list = JSON.parseObject(data1.toString(), List.class, Feature.OrderedField);
            for (Object o : list) {
                Map listDateMap = JSON.parseObject(o.toString(), Map.class, Feature.OrderedField);
                Map masterField = new LinkedHashMap<>();
                Map masterFieldVal = new LinkedHashMap<>();
                masterFieldVal.put("productCode", listDateMap.get(物料代码));//产品编码
                masterFieldVal.put("productName", listDateMap.get(物料名称));//产品名称
                masterFieldVal.put("batchNumber", listDateMap.get(批号));//批号
                masterFieldVal.put("warehouseName", listDateMap.get(仓库名称));//仓库名称
                masterFieldVal.put("inventoryQuantity", listDateMap.get(基本单位数量));//库存数量
                masterField.put("masterFieldVal", masterFieldVal);
                dataList.add(masterField);
            }
            map.put("totalNum", data.get("ROWCOUNT"));
            map.put("dataList", dataList);
            soSsRequestVo.setData(map);
        } catch (Exception e) {
            e.printStackTrace();
        }

        //将ERP格式变换为CRM格式
        result.setMessage(soSsRequestVo.getMessage());
        result.setCode(soSsRequestVo.getStatusCode());
        result.setData(soSsRequestVo.getData());

        return result;
    }

}
