package com.lqkj.demo.controller;

import com.lqkj.demo.Constants;
import com.lqkj.demo.utils.LocalMACUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

@CrossOrigin
@RestController
@RequestMapping("/lqkj/inspect")
@Slf4j
public class InspectController {
    private static final String localMacString = "localMac";



    @PostMapping(value = "/mac")
    public Boolean inspectMac(@RequestBody(required = false) Map Mac) {
        System.out.println("有登录" + Mac);
        if (null != Mac && null != Mac.get(localMacString)) {
            if (Constants.entity.containsKey(Mac.get(localMacString))) {
                return true;
            }
        }
        return false;
    }

    @GetMapping(value = "/getMac")
    public String getMac() throws SocketException, UnknownHostException {
        System.out.println("执行了");
        String localMac = LocalMACUtil.getLocalMac(InetAddress.getLocalHost());
        return localMac;
    }

    @PostMapping(value = "/resartMac")
    public String resartMac(@RequestBody(required = false) Map Mac) {
        System.out.println("有登录" + Mac);
        if (null != Mac && null != Mac.get(localMacString)) {
            if (Constants.entity.containsKey(Mac.get(localMacString))) {
                return "已有mac";
            } else {
                Constants.entity.put(Mac.get(localMacString).toString(),Mac.get(localMacString).toString());
                return "ok";
            }
        }
        return "ok";
    }
}
