package com.lqkj.demo;


import com.lqkj.demo.utils.oConvertUtil;
import lombok.extern.slf4j.Slf4j;
//import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.Environment;

import java.net.InetAddress;
import java.net.UnknownHostException;

@SpringBootApplication
@Slf4j
@EnableAutoConfiguration(exclude = {DataSourceAutoConfiguration.class})
public class JintaiDomeApplication extends SpringBootServletInitializer {
        @Override
    protected SpringApplicationBuilder configure(SpringApplicationBuilder application) {
        return application.sources(JintaiDomeApplication.class);
    }
//    public static class CustomGenerator implements BeanNameGenerator {
//
//        @Override
//        public String generateBeanName(BeanDefinition definition, BeanDefinitionRegistry registry) {
//            return definition.getBeanClassName();
//        }
//    }

    public static void main(String[] args) throws UnknownHostException {

//        ConfigurableApplicationContext application = new SpringApplicationBuilder(JintaiDomeApplication.class)
//                .beanNameGenerator(new CustomGenerator())
//                .run(args);
        ConfigurableApplicationContext application = SpringApplication.run(JintaiDomeApplication.class, args);
        Environment env = application.getEnvironment();
        String ip = InetAddress.getLocalHost().getHostAddress();
        String port = env.getProperty("server.port");
        String path = oConvertUtil.getString(env.getProperty("server.servlet.context-path"));
        log.info("\n----------------------------------------------------------\n\t" +
                "Application wmssystem is running! Access URLs:\n\t" +
                "Local: \t\thttp://localhost:" + port + path + "/\n\t" +
                "External: \thttp://" + ip + ":" + port + path + "/\n\t" +
                "Swagger-ui: \thttp://" + ip + ":" + port + path + "/swagger-ui.html\n\t" +
                "Doc文档: \thttp://" + ip + ":" + port + path + "/doc.html\n" +
                "----------------------------------------------------------");
    }

}
