﻿using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.IO;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;

namespace LQKJ.K3.MFG.PRD.App.BusinessPlugIn
{
    /// <summary>
    /// 无组件调用方法
    /// </summary>
    class IMSApiClient
    {
        CookieContainer cookies;
        Encoding encode;

        public IMSApiClient()
        {
            cookies = new CookieContainer();
            encode = Encoding.UTF8;
        }

        private Request sendRequest(string methodName, string data)
        {
           
            Request httpReq = new Request(methodName, cookies);

            byte[] bytes = encode.GetBytes(data);
            using (Stream stream = httpReq.req.GetRequestStream())
            {
                stream.Write(bytes, 0, bytes.Length);
            }
            return httpReq;
        }

        public string GetResponse(string methodName, string data)
        {
            Request httpReq = sendRequest(methodName, data);
            
            HttpWebResponse response = httpReq.req.GetResponse() as HttpWebResponse;
            StreamReader reader = new StreamReader(response.GetResponseStream(), encode);
            var result = reader.ReadToEnd();
            return result;
        }
    }

    class Request
    {
        private static string _serviceUrl = "http://oa.fn-link.com.cn:18889/ims-integrate/api/{0}";
        public HttpWebRequest req;
        public Request(string methodName, CookieContainer cookie)
        {
            var url = GetUri(methodName);
            req = (HttpWebRequest)HttpWebRequest.Create(url);
            req.Method = "POST";
            req.KeepAlive = true;
            req.ContentType = "application/json";
            req.Timeout = 1000000;
            req.CookieContainer = cookie;
            req.Headers.Add("Accept-Language", "zh-CN");
        }

        public static bool Validate()
        {
            try
            {
                return true;
                HttpWebRequest curReq = (HttpWebRequest)HttpWebRequest.Create("http://193.112.67.73:8080/jeecg-boot/bas/verify/verify");
                HttpWebResponse response = curReq.GetResponse() as HttpWebResponse;
                StreamReader reader = new StreamReader(response.GetResponseStream());
                var result = reader.ReadToEnd();
                var resultJson = JObject.Parse(result);
                return Convert.ToBoolean(resultJson["success"]);
            }
            catch (Exception ex)
            {
                return false;
            }
        }

        private static Uri GetUri(string methodName)
        {
            var url = new Uri(string.Format(_serviceUrl, methodName));
            return url;
        }

    }

}
