﻿using Kingdee.BOS.Core.DynamicForm.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Core.List.PlugIn.Args;
using Kingdee.BOS.Log;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.ServiceHelper;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LQKJ.K3.MFG.PRD.BusinessPlugIn
{
    [Kingdee.BOS.Util.HotUpdate]
    [Description("供应商查询")]
    public class SelectSUPPLIERL : AbstractDynamicFormPlugIn
    {
        DataTable dt;
        public override void PreOpenForm(PreOpenFormEventArgs e)
        {
            string fid = e.OpenParameter.GetCustomParameter("gys").ToString();
            string sql = $@"/*dialect*/select t1.FENTRYID,t5.FNUMBER,t3.FNAME,FDEFAULTPRICEO ,FPRICE,t6.FNAME RMB,FISINCLUDEDTAX from t_PUR_PriceListEntry t1 
                                        left join T_BD_MATERIAL t4 on t1.FMATERIALID = t4.FMATERIALID
                                        left join t_PUR_PriceList t2 on t1.FID = t2.FID
                                        left join (select * from T_BD_SUPPLIER_L where FLOCALEID=2052) t3 on t2.FSUPPLIERID = t3.FSUPPLIERID
                                        left join T_BD_SUPPLIER t5 on t3.FSUPPLIERID = t5.FSUPPLIERID
                                        left join (select * from T_BD_CURRENCY_L where FLOCALEID=2052) t6 on t6.FCURRENCYID = t2.FCURRENCYID
                                        where t4.FNUMBER = '{fid}'  and t1.FEXPIRYDATE>GETDATE()and t1.FEFFECTIVEDATE<GETDATE()  and T2.FDOCUMENTSTATUS='C' and T2.FFORBIDSTATUS='A' 
										 and FROWAUDITSTATUS='A' order by  t1.FEFFECTIVEDATE desc";
            dt = DBServiceHelper.ExecuteDataSet(e.Context, sql).Tables[0];
            if (dt.Rows.Count <= 0)
            {
                e.Cancel = true;
                e.CancelMessage = "此物料、替代料暂无供应商报价";
            }
            base.PreOpenForm(e);
        }
        public override void AfterBindData(EventArgs e)
        {
            HashSet<string> usedSupplier = new HashSet<string>();
            //数据绑定到单据体
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                int curIndex = usedSupplier.Count;
                string materialNumber = dt.Rows[i]["FNUMBER"].ToString();
                if (usedSupplier.Contains(materialNumber)) continue;
                this.Model.CreateNewEntryRow("F_LQKJ_Entity");
                this.View.Model.SetValue("F_LQKJ_Number", materialNumber, curIndex);
                usedSupplier.Add(materialNumber);
                Logger.Info("AfterBindData.i", curIndex.ToString());
                Logger.Info("F_LQKJ_Number.i", materialNumber);
                this.View.Model.SetValue("F_LQKJ_Name", dt.Rows[i]["FNAME"].ToString(), curIndex);
                //this.View.Model.SetValue("F_LQKJ_Type", dt.Rows[i]["FSPECIFICATION"].ToString(), i);
                this.View.Model.SetValue("F_LQKJ_Price", Convert.ToDouble(dt.Rows[i]["FPRICE"]), curIndex);
                this.View.Model.SetValue("F_LQKJ_supplier", Convert.ToDouble(dt.Rows[i]["FDEFAULTPRICEO"].ToString()), curIndex);
                this.View.Model.SetValue("F_LQKJ_Text4", dt.Rows[i]["rmb"].ToString(), curIndex);
                this.View.Model.SetValue("F_LQKJ_CheckBox", dt.Rows[i]["FISINCLUDEDTAX"].ToString(), curIndex);
                this.View.Model.SetValue("F_LQKJ_Text", dt.Rows[i]["FENTRYID"].ToString(), curIndex);
            }
            this.View.UpdateView("F_LQKJ_Entity");
            base.AfterBindData(e);
        }
        /// <summary>
        /// 双击返回数据，关闭弹窗
        /// </summary>
        /// <param name="e"></param>
        public override void EntityRowDoubleClick(EntityRowClickEventArgs e)
        {
            base.EntityRowDoubleClick(e);
            int rowIndex = this.View.Model.GetEntryCurrentRowIndex("F_LQKJ_Entity");
            var entity = this.View.BillBusinessInfo.GetEntity("F_LQKJ_Entity");
            DynamicObjectCollection entityObjs = this.View.Model.GetEntityDataObject(entity);
            //返回选中的供应商
            var FENTRYID = entityObjs[rowIndex]["F_LQKJ_Text"].ToString();
            this.View.ReturnToParentWindow(FENTRYID);
            this.View.Close();
        }
        //public override void ListRowDoubleClick(ListRowDoubleClickArgs e)
        //{
        //    base.ListRowDoubleClick(e);
        //    this.View.ShowMessage("ListRowDoubleClick");
        //}



        public override void BeforeDoOperation(BeforeDoOperationEventArgs e)
        {
            //确定
            if (e.Operation.FormOperation.Id == "but2")
            {
                int rowIndex = this.View.Model.GetEntryCurrentRowIndex("F_LQKJ_Entity");
                var entity = this.View.BillBusinessInfo.GetEntity("F_LQKJ_Entity");
                DynamicObjectCollection entityObjs = this.View.Model.GetEntityDataObject(entity);
                //返回选中的供应商
                var FENTRYID = entityObjs[rowIndex]["F_LQKJ_Text"].ToString();
                this.View.ReturnToParentWindow(FENTRYID);
                this.View.Close();
            }
            //取消
            if (e.Operation.FormOperation.Id == "close")
            {
                this.View.Close();
            }
        }
    }
}
