﻿using Kingdee.BOS.Core.Bill.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.ServiceHelper;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LQKJ.K3.MFG.PRD.BusinessPlugIn
{
    [Kingdee.BOS.Util.HotUpdate]
    [Description("采购退料单单位转换")]
    public class UnitMRBPlugin : AbstractBillPlugIn
    {
        HashSet<int> flagHash = new HashSet<int>();
        public override void DataChanged(DataChangedEventArgs e)
        {
            if (this.Context.ServiceType == Kingdee.BOS.WebType.WebService)
            {
                if (e.Field.Key.ToUpperInvariant() == "F_LQKJ_QTY")
                {
                    var unit = this.View.Model.GetValue("FUnitID", e.Row) as DynamicObject;

                    if (unit == null) return;
                    if (unit["Number"].ToString() != "KPcs") return;
                    if (flagHash.Contains(e.Row)) return;
                    flagHash.Add(e.Row);
                    var str = e.Field.ToString();
                    var a = this.View.Model.GetValue("FMaterialId", e.Row);
                    var objs = a as DynamicObject;
                    var materialId = objs["msterID"].ToString();
                    string sql = $@"/*dialect*/select FSTOREUNITID,FPURCHASEUNITID,
                                    t4.FCONVERTDENOMINATOR kcFCONVERTDENOMINATOR, t4.FCONVERTNUMERATOR kcFCONVERTNUMERATOR,
                                    t5.FCONVERTDENOMINATOR cgFCONVERTDENOMINATOR, t5.FCONVERTNUMERATOR cgFCONVERTNUMERATOR
                                    from T_BD_MATERIAL t1
                                    left join t_BD_MaterialStock t2 on t1.FMATERIALID=t2.FMATERIALID
                                    left join t_bd_MaterialPurchase t3 on t2.FMATERIALID=t3.FMATERIALID
                                    left join T_BD_UNITCONVERTRATE t4 on t4.FUNITID=t2.FSTOREUNITID
                                    left join T_BD_UNITCONVERTRATE t5 on t5.FUNITID=t3.FPURCHASEUNITID where t1.FMASTERID={materialId}";
                    DataTable dt = DBServiceHelper.ExecuteDataSet(this.Context, sql).Tables[0];
                    if (dt.Rows.Count > 0)
                    {
                        var kc = Convert.ToDouble(dt.Rows[0]["kcFCONVERTDENOMINATOR"]);
                        var kc2 = Convert.ToDouble(dt.Rows[0]["kcFCONVERTNUMERATOR"]);
                        var cg = Convert.ToDouble(dt.Rows[0]["cgFCONVERTDENOMINATOR"]);
                        var cg2 = Convert.ToDouble(dt.Rows[0]["cgFCONVERTNUMERATOR"]);
                        var number = Convert.ToDouble(e.NewValue);
                        //num /FCONVERTDENOMINATOR * FCONVERTNUMERATOR
                        var basicUnit = number * kc2 / kc;
                        //num* FCONVERTDENOMINATOR / FCONVERTNUMERATOR
                        var StockUnit = basicUnit * cg / cg2;
                        this.View.Model.SetValue("FRMREALQTY", StockUnit, e.Row);
                        this.View.InvokeFieldUpdateService("FRMREALQTY", e.Row);
                    }

                }
            }
            base.DataChanged(e);

        }
    }
}
