﻿using Kingdee.BOS.Core.Bill.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Log;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.ServiceHelper;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LQKJ.K3.MFG.PRD.BusinessPlugIn
{
    [Kingdee.BOS.Util.HotUpdate]
    [Description("单位转换")]
    public class UnitRransformationPlugin : AbstractBillPlugIn
    {
        HashSet<int> flagHash = new HashSet<int>();
        public override void DataChanged(DataChangedEventArgs e)
        {
            //Logger.Info("单位换算", "开始：" + e.Field.Key.ToUpperInvariant());
            //Logger.Info("单位换算", "开始：" + this.Context.ServiceType.ToString());
            if (this.Context.ServiceType == Kingdee.BOS.WebType.WebService)
            {
                if (e.Field.Key.ToUpperInvariant() == "FSUPDELQTY")
                {
                    if (flagHash.Contains(e.Row)) return;
                    flagHash.Add(e.Row);
                    var str = e.Field.ToString();
                    var a = this.View.Model.GetValue("FMaterialId", e.Row);
                    var objs = a as DynamicObject;
                    var materialId = objs["msterID"].ToString();
                    Logger.Info("单位换算", "计算前数量：" + e.NewValue);
                    string sql = $@"/*dialect*/select FSTOREUNITID,FPURCHASEUNITID,
                                    t4.FCONVERTDENOMINATOR kcFCONVERTDENOMINATOR, t4.FCONVERTNUMERATOR kcFCONVERTNUMERATOR,
                                    t5.FCONVERTDENOMINATOR cgFCONVERTDENOMINATOR, t5.FCONVERTNUMERATOR cgFCONVERTNUMERATOR
                                    from T_BD_MATERIAL t1
                                    left join t_BD_MaterialStock t2 on t1.FMATERIALID=t2.FMATERIALID
                                    left join t_bd_MaterialPurchase t3 on t2.FMATERIALID=t3.FMATERIALID
                                    left join T_BD_UNITCONVERTRATE t4 on t4.FUNITID=t2.FSTOREUNITID
                                    left join T_BD_UNITCONVERTRATE t5 on t5.FUNITID=t3.FPURCHASEUNITID where t1.FMASTERID={materialId}";
                    DataTable dt = DBServiceHelper.ExecuteDataSet(this.Context, sql).Tables[0];
                    if (dt.Rows.Count > 0)
                    {
                        var kc = Convert.ToDouble(dt.Rows[0]["kcFCONVERTDENOMINATOR"]);
                        var kc2 = Convert.ToDouble(dt.Rows[0]["kcFCONVERTNUMERATOR"]);
                        var cg = Convert.ToDouble(dt.Rows[0]["cgFCONVERTDENOMINATOR"]);
                        var cg2 = Convert.ToDouble(dt.Rows[0]["cgFCONVERTNUMERATOR"]);
                        var number = Convert.ToDouble(e.NewValue);

                        Logger.Info("单位换算", "kc：" + kc);
                        Logger.Info("单位换算", "kc2：" + kc2);
                        Logger.Info("单位换算", "cg：" + cg);
                        Logger.Info("单位换算", "cg2：" + cg2);

                        //num /FCONVERTDENOMINATOR * FCONVERTNUMERATOR
                        var basicUnit = number * kc2 / kc;
                        //num* FCONVERTDENOMINATOR / FCONVERTNUMERATOR
                        var StockUnit = basicUnit * cg / cg2;
                        Logger.Info("单位换算", "计算后数量：" + StockUnit);
                        this.View.Model.SetValue("FActReceiveQty", StockUnit, e.Row);
                        this.View.InvokeFieldUpdateService("FActReceiveQty", e.Row);
                        this.View.UpdateView("FDetailEntity");
                    }

                }
                //if (e.Field.Key.ToUpperInvariant() == "FACTRECEIVEQTY")
                //{
                //    this.View.Model.SetValue("FSUPDELQTY", this.View.Model.GetValue("FActReceiveQty", e.Row), e.Row);
                //}
            }
            //Logger.Info("单位换算", "结束：" + e.Field.Key.ToUpperInvariant());
            base.DataChanged(e);

        }
    }
}
