﻿using Kingdee.BOS.Core.DynamicForm;
using Kingdee.BOS.Core.DynamicForm.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.ServiceHelper;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Dynamic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LQKJ.K3.MFG.PRD.BusinessPlugIn
{
    [Kingdee.BOS.Util.HotUpdate]
    [Description("替代料查询")]
    public class SelectReplacePlugin : AbstractDynamicFormPlugIn
    {
        DataTable dt;
        public override void PreOpenForm(PreOpenFormEventArgs e)
        {
             base.PreOpenForm(e);
            string fid = e.OpenParameter.GetCustomParameter("FID").ToString();
            string FMATERIALID = e.OpenParameter.GetCustomParameter("FMATERIALID").ToString();
            string sql = $@"/*dialect*/select T1.FNUMBER,T1_L.FNAME,T1_L.FSPECIFICATION,J1.FPRICE,t2.FNAME as gysname,J2.FSUPPLIERID,
                    t3.FNAME as rmb, j2.FNUMBER as cjnumber,j1.FMATERIALID from T_BD_MATERIAL T1
                    left join T_BD_MATERIAL_L T1_L on t1.FMATERIALID=T1_L.FMATERIALID
                    left join t_PUR_PriceListEntry J1 ON J1.FMATERIALID=T1.FMATERIALID
                    LEFT JOIN t_PUR_PriceList J2 ON J2.FID=J1.FID
					left join t_BD_Supplier_l t2 on t2.FSUPPLIERID=J2.FSUPPLIERID
					left join T_BD_CURRENCY_L t3 on t3.FCURRENCYID=j2.FCURRENCYID
					where t1.FMATERIALID   in (
                    
                    select t7.FMATERIALID from T_PUR_ReqEntry T1
                    LEFT JOIN T_PUR_REQENTRY_R T2 on t1.FID=t2.FID 
                    left join T_PLN_PLANORDER T3 on t2.FSRCBILLNO=t3.FBILLNO 
                    LEFT JOIN T_PLN_PLANORDER_B T4 ON T3.FID=T4.FID 
                    LEFT JOIN T_SAL_ORDER T5  ON T4.FSALEORDERNO=T5.FBILLNO
                    left join T_SAL_ORDERENTRY	T6 ON T5.FID=T6.FID --FBOMID
                    left join T_ENG_BOMCHILD T7 ON T6.FBOMID=T7.FID
                    left join T_ENG_BOMCHILD_A t8 on t7.FENTRYID=t8.FENTRYID
                    where T1.FID={fid}   and 
                    FPARENTROWID in (SELECT FROWID FROM T_ENG_BOMCHILD T1 
                    LEFT JOIN T_ENG_BOMCHILD_A T2 ON T1.FENTRYID=T2.FENTRYID
                    WHERE T1.FMATERIALID={FMATERIALID} )
                    union all
                    select t7.FMATERIALID from T_PUR_ReqEntry T1
                    LEFT JOIN T_PUR_REQENTRY_R T2 on t1.FID=t2.FID 
                    left join T_PLN_PLANORDER T3 on t2.FSRCBILLNO=t3.FBILLNO
                    LEFT JOIN T_PLN_PLANORDER_B T4 ON T3.FID=T4.FID
                    LEFT JOIN T_SAL_ORDER T5  ON T4.FSALEORDERNO=T5.FBILLNO 
                    left join T_SAL_ORDERENTRY	T6 ON T5.FID=T6.FID 
                    left join T_ENG_BOMCHILD T7 ON T6.FBOMID=T7.FID 
                    left join T_ENG_BOMCHILD_A t8 on t7.FENTRYID=t8.FENTRYID
                    where T1.FID={fid}  AND T7.FMATERIALID={FMATERIALID}
                        )  and j1.FMATERIALID!={FMATERIALID} ";
           dt = DBServiceHelper.ExecuteDataSet(e.Context, sql).Tables[0];
            //去除价格为空的数据（没有报价信息）
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                if (dt.Rows[i]["FPRICE"].ToString() == "")
                {
                    dt.Rows.RemoveAt(i);
                }
            }
            if (dt.Rows.Count <= 0)
            {
                e.Cancel = true;
                e.CancelMessage = "此物料暂无报价";
            }
        }
        public override void AfterBindData(EventArgs e)
        {
            base.AfterBindData(e);
            string fid = this.View.OpenParameter.GetCustomParameter("FID").ToString();
            string FMATERIALID = this.View.OpenParameter.GetCustomParameter("FMATERIALID").ToString();
            //去除价格为空的数据（没有报价信息）
            this.Model.BatchCreateNewEntryRow("F_LQKJ_Entity", dt.Rows.Count - 1);
            //数据绑定到单据体
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                    this.View.Model.SetValue("F_LQKJ_Number", dt.Rows[i]["FNUMBER"].ToString(), i);
                    this.View.Model.SetValue("F_LQKJ_Name", dt.Rows[i]["FNAME"].ToString(), i);
                    this.View.Model.SetValue("F_LQKJ_Type", dt.Rows[i]["FSPECIFICATION"].ToString(), i);
                    this.View.Model.SetValue("F_LQKJ_Price", dt.Rows[i]["FPRICE"].ToString(), i);
                    this.View.Model.SetValue("F_LQKJ_supplier", dt.Rows[i]["gysname"].ToString(), i);
                    this.View.Model.SetValue("F_LQKJ_Text4", dt.Rows[i]["rmb"].ToString(), i);
                    this.View.Model.SetValue("F_LQKJ_Text", dt.Rows[i]["cjnumber"].ToString(), i);
                    this.View.Model.SetValue("F_LQKJ_Text1", dt.Rows[i]["FMATERIALID"].ToString(), i);
                    this.View.Model.SetValue("F_LQKJ_Text2", dt.Rows[i]["FSUPPLIERID"].ToString(), i);
            } 
            this.View.UpdateView("F_LQKJ_Entity");
        }
        public override void BeforeDoOperation(BeforeDoOperationEventArgs e)
        {
            //确定
            if (e.Operation.FormOperation.Id == "but2")
            {
                var synum=Convert.ToDouble(this.View.OpenParameter.GetCustomParameter("FREMAINQTY"));
                int num = Convert.ToInt32(this.Model.GetValue("F_LQKJ_Integer").ToString());//数量
                int rowIndex = this.View.Model.GetEntryCurrentRowIndex("F_LQKJ_Entity");
                var entity = this.View.BillBusinessInfo.GetEntity("F_LQKJ_Entity");
                DynamicObjectCollection entityObjs = this.View.Model.GetEntityDataObject(entity);
                if (num > synum)
                {
                    this.View.ShowWarnningMessage("数量已超额，数量不能超过"+synum);
                }
                else
                {
                    //返回选中的替代料及数量
                    var gys = entityObjs[rowIndex]["F_LQKJ_Text2"].ToString();
                    var wlid = entityObjs[rowIndex]["F_LQKJ_Text1"].ToString();
                    var price = entityObjs[rowIndex]["F_LQKJ_Price"].ToString();
                    List<string> list = new List<string>();
                    list.Add(gys);//供应商
                    list.Add(wlid);//物料
                    list.Add(num.ToString());//数量
                    list.Add(price);//单价
                    this.View.ReturnToParentWindow(list);
                    this.View.Close();
                }
            }
            //取消
            if (e.Operation.FormOperation.Id == "close")
            {
                this.View.Close();
            }

        }
      
    }
}
