﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Transactions;
using Kingdee.BOS;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core;
using Kingdee.BOS.Core.Bill;
using Kingdee.BOS.Core.DynamicForm;
using Kingdee.BOS.Core.DynamicForm.Operation;
using Kingdee.BOS.Core.DynamicForm.OperationWebService;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Core.Interaction;
using Kingdee.BOS.Core.List;
using Kingdee.BOS.Core.Metadata;
using Kingdee.BOS.Core.Metadata.ConvertElement;
using Kingdee.BOS.Core.Metadata.ConvertElement.ServiceArgs;
using Kingdee.BOS.Core.Metadata.EntityElement;
using Kingdee.BOS.Core.Metadata.FormElement;
using Kingdee.BOS.Core.Validation;
using Kingdee.BOS.JSON;
using Kingdee.BOS.Log;
using Kingdee.BOS.Orm;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.ServiceFacade.KDServiceFx;
using Kingdee.BOS.ServiceHelper;
using Kingdee.BOS.Util;
using Kingdee.BOS.WebApi.ServicesStub;

namespace LQKJ.ERPWebApi.Stub
{
    //自定义webapi接口
    public class CustomWebApiService : AbstractWebApiBusinessService
    {

        public CustomWebApiService(KDServiceContext context)
            : base(context)
        {
            //
        }
        //执行sql并返回查询结果  sql脚本
        public SQLResult ExecutDataSet(string sql)
        {
            SQLResult sQLResult = new SQLResult();
            if (string.IsNullOrWhiteSpace(sql))
            {
                sQLResult.resultCode = "0001";
                sQLResult.resultMsg = "参数为空，请传正确的参数！";
                return sQLResult;
            }
            if (this.KDContext.Session.AppContext == null)
            {
                sQLResult.resultCode = "0010";
                sQLResult.resultMsg = "请重新登录！";
                return sQLResult;
            }
            sQLResult.resultCode = "0000";
            sql = DESHelper.Decrypt(sql, "MES&&DES");
            try
            {
                sQLResult.data = DBServiceHelper.ExecuteDataSet(this.KDContext.Session.AppContext, sql);
            }
            catch (Exception ex)
            {
                sQLResult.resultCode = "0001";
                sQLResult.resultMsg = ex.Message;
            }
            return sQLResult;
        }
        //执行sql并返回查询结果 返回字典集合
        public SQLResult ExecuteDynamicObject(string sql)
        {
            SQLResult sQLResult = new SQLResult();
            if (string.IsNullOrWhiteSpace(sql))
            {
                sQLResult.resultCode = "0001";
                sQLResult.resultMsg = "参数为空，请传正确的参数！";
                return sQLResult;
            }
            if (this.KDContext.Session.AppContext == null)
            {
                sQLResult.resultCode = "0010";
                sQLResult.resultMsg = "请重新登录！";
                return sQLResult;
            }
            sQLResult.resultCode = "0000";
            sql = DESHelper.Decrypt(sql, "MES&&DES");
            try
            {
                sQLResult.data = DBServiceHelper.ExecuteDynamicObject(this.KDContext.Session.AppContext, sql);
            }
            catch (Exception ex)
            {
                sQLResult.resultCode = "0001";
                sQLResult.resultMsg = ex.Message;
            }
            return sQLResult;
        }
        public SQLResult ExecutBatch(string sql)
        {
            SQLResult sQLResult = new SQLResult();
            if (string.IsNullOrWhiteSpace(sql))
            {
                sQLResult.resultCode = "0001";
                sQLResult.resultMsg = "参数为空，请传正确的参数！";
                return sQLResult;
            }
            if (this.KDContext.Session.AppContext == null)
            {
                sQLResult.resultCode = "0010";
                sQLResult.resultMsg = "请重新登录！";
                return sQLResult;
            }
            sQLResult.resultCode = "0000";
            sql = DESHelper.Decrypt(sql, "MES&&DES");
            var sqls = sql.Split(';').ToList();
            try
            {
                sQLResult.data = DBServiceHelper.ExecuteBatch(this.KDContext.Session.AppContext, sqls);
            }
            catch (Exception ex)
            {
                sQLResult.resultCode = "0001";
                sQLResult.resultMsg = ex.Message;
            }
            return sQLResult;
        }


        private IBillView CreateBillView(string formId, JSONObject model, out bool isToAudit)
        {
            //读取物料的元数据
            FormMetadata meta = MetaDataServiceHelper.Load(this.KDContext.Session.AppContext, formId) as FormMetadata;
            Form form = meta.BusinessInfo.GetForm();
            //创建用于引入数据的单据view
            Type type = Type.GetType("Kingdee.BOS.Web.Bill.BillView,Kingdee.BOS.Web");
            var billView = (IDynamicFormViewService)Activator.CreateInstance(type);
            //开始初始化billView：
            //创建视图加载参数对象，指定各种参数，如FormId, 视图(LayoutId)等
            BillOpenParameter openParam = CreateOpenParameter(meta, model, out isToAudit);
            //动态领域模型服务提供类，通过此类，构建MVC实例
            var provider = form.GetFormServiceProvider();
            billView.Initialize(openParam, provider);
            return billView as IBillView;
        }

        private BillOpenParameter CreateOpenParameter(FormMetadata meta, JSONObject model, out bool isToAudit)
        {
            Form form = meta.BusinessInfo.GetForm();
            //指定FormId, LayoutId
            BillOpenParameter openParam = new BillOpenParameter(form.Id, meta.GetLayoutInfo().Id);
            //数据库上下文
            openParam.Context = this.KDContext.Session.AppContext;
            //本单据模型使用的MVC框架
            openParam.ServiceName = form.FormServiceName;
            //随机产生一个不重复的PageId，作为视图的标识
            openParam.PageId = Guid.NewGuid().ToString();
            //元数据
            openParam.FormMetaData = meta;
            //界面状态：新增 (修改、查看)
            object pkValue;
            if (!model.TryGetValue(form.PkFieldName, out pkValue))
            {
                openParam.Status = OperationStatus.ADDNEW;
                isToAudit = true;
            }
            else
            {
                openParam.Status = OperationStatus.EDIT;
                isToAudit = false;
                //单据主键：本案例演示新建物料，不需要设置主键
                openParam.PkValue = pkValue;
            }
            //界面创建目的：普通无特殊目的 （为工作流、为下推、为复制等）
            openParam.CreateFrom = CreateFrom.Default;
            var plugs = form.CreateFormPlugIns();
            openParam.SetCustomParameter(FormConst.PlugIns, plugs);
            PreOpenFormEventArgs args = new PreOpenFormEventArgs(this.KDContext.Session.AppContext, openParam);
            foreach (var plug in plugs)
            { //触发插件PreOpenForm事件，供插件确认是否允许打开界面
                plug.PreOpenForm(args);
            }
            return openParam;
        }

        /// <summary>
        /// 下推并保存
        /// </summary>
        /// <returns></returns>
        public Result PushAndSave(PushAndSaveArgs pushAndSaveArgs)
        {
            var isAutoSubmit = pushAndSaveArgs.isAutoSubmit;
            Result result = new Result();
            if (pushAndSaveArgs == null)
            {
                result.resultCode = "0001";
                result.resultMsg = "参数为空，请传正确的参数！";
                return result;
            }
            Logger.Info("pushAndSaveArgs", JsonUtil.Serialize(pushAndSaveArgs));
            result.performances.Add(new Performance() { stage = "开始", pointTime = DateTime.Now });
            if (this.KDContext.Session.AppContext == null)
            {
                result.resultCode = "0010";
                result.resultMsg = "请重新登录！";
                return result;
            }

            List<ListSelectedRow> listSelectedRows = new List<ListSelectedRow>();
            DynamicObject dynamicObject;

            FormMetadata billFormMetadata = null;
            try
            {
                billFormMetadata = MetaDataServiceHelper.Load(this.KDContext.Session.AppContext, pushAndSaveArgs.FormId) as FormMetadata;
            }
            catch (KDException ex)
            {
                result.resultCode = "0001";
                result.resultMsg = $"单据唯一标识{pushAndSaveArgs.FormId}参数不正确！";
                return result;
            }

            bool isToAudit;
            IBillView billView = CreateBillView(pushAndSaveArgs.FormId, pushAndSaveArgs.Model, out isToAudit);
            if (pushAndSaveArgs.SrcIds == null || pushAndSaveArgs.SrcIds.Count == 0)
            {
                //构建一个IBillView实例
                ((IDynamicFormViewService)billView).LoadData();
                dynamicObject = billView.Model.DataObject;
                result.performances.Add(new Performance() { stage = "加载数据完成", pointTime = DateTime.Now });
            }
            else
            {
                foreach (string srcId in pushAndSaveArgs.SrcIds)
                {
                    listSelectedRows.Add(new ListSelectedRow("0", srcId, pushAndSaveArgs.SrcIds.IndexOf(srcId), pushAndSaveArgs.SrcFormId) { EntryEntityKey = pushAndSaveArgs.SrcEntryKey });
                }
                var convertRules = ConvertServiceHelper.GetConvertRules(this.KDContext.Session.AppContext, pushAndSaveArgs.SrcFormId, pushAndSaveArgs.FormId);
                ConvertRuleElement convertRuleElement2 = convertRules.Where(rule => rule.Id == pushAndSaveArgs.ConvertRule).FirstOrDefault();

                if (convertRuleElement2 == null)
                {
                    result.resultCode = "0001";
                    result.resultMsg = $"源单({pushAndSaveArgs.SrcFormId})、目标单({pushAndSaveArgs.FormId})和单据转换({pushAndSaveArgs.ConvertRule})，其中有一个参数不正确！";
                    return result;
                }
                PushArgs serviceArgs = new PushArgs(convertRuleElement2, listSelectedRows.ToArray())
                {
                    TargetBillTypeId = "",//billtype
                                          //TargetOrgId ="1",
                                          //CustomParams = customParams,
                                          //EntryUpperLimitValue = retInfo.EntryUpperLimitValue
                };
                var pushOption = OperateOption.Create();
                pushOption.SetVariableValue("SelectByBillId", false);
                pushOption.SetVariableValue("ConvertType", "ManualPush");
                ConvertOperationResult innerConvertOperationResult = null;
                try
                {
                    var EntryName = "";
                    var EntryKey = "";
                    foreach (var item in pushAndSaveArgs.Model)
                    {
                        Element element1;
                        Element element = billView.BillBusinessInfo.GetElement(item.Key.Trim());
                        if (7 == 0 || element != null)
                        {
                            element1= element;
                        }
                        int num = item.Key.Trim().IndexOf("#");
                        if (num > -1)
                        {
                            string key = item.Key.Trim().Substring(num + 2);
                            element = billView.BillBusinessInfo.GetElement(key);
                        }
                        element1= element;
                        if (element == null) continue;

                        if (element is EntryEntity)
                        {
                            EntryName = (element1 as EntryEntity).EntryName;
                            EntryKey = (element1 as EntryEntity).Key;
                        }
                        else
                        {
                            continue;
                        }
                    }
                    innerConvertOperationResult = ConvertServiceHelper.Push(this.KDContext.Session.AppContext, serviceArgs, pushOption);
                    Dictionary<string, int> HSsrcId = new Dictionary<string, int>();
                    List<string> SrcIdlist = pushAndSaveArgs.SrcIds;
                    var DataEntities = innerConvertOperationResult.TargetDataEntities;
                    if(!EntryName.IsNullOrEmptyOrWhiteSpace())
                    {
                        foreach (var item in DataEntities)
                        {
                            var Entitys = item.DataEntity[EntryName] as DynamicObjectCollection;
                            foreach (var Entity in Entitys)
                            {
                                var LinkSId = (Entity[EntryKey + "_Link"] as DynamicObjectCollection)[0]["SId"].ToString();
                                if (HSsrcId.ContainsKey(LinkSId))
                                {
                                    HSsrcId[LinkSId] = HSsrcId[LinkSId] + 1;
                                }
                                else
                                {
                                    HSsrcId.Add(LinkSId, 1);
                                }
                            }
                        }
                        string NotInId = "";
                        if (HSsrcId.Count > 0)
                        {
                            foreach (var Id in SrcIdlist)
                            {
                                if (!HSsrcId.ContainsKey(Id))
                                {
                                    NotInId += Id + ",";
                                }
                                else
                                {
                                    if (HSsrcId[Id] == 0)
                                    {
                                        NotInId += Id + ",";
                                    }
                                    else
                                    {
                                        HSsrcId[Id] = HSsrcId[Id] - 1;
                                    }
                                }
                            }
                        }
                        if (NotInId != "")
                        {
                            result.resultMsg = $"同步失败，源单分录主键{NotInId} 未下推成功!";
                            result.resultCode = "0001";
                            return result;
                        }
                    }
                

                }
                catch (KDException ex)
                {
                    if (ex.Code == "BF")
                    {
                        result.resultMsg = $"源单分录主键{pushAndSaveArgs.SrcEntryKey}配置不正确!";
                    }
                    else
                    {
                        result.resultMsg = ex.Message;
                    }
                    result.resultCode = "0001";
                    return result;
                }

                if (!innerConvertOperationResult.IsSuccess)
                {
                    GenMessages(result, innerConvertOperationResult, "下推");
                    return result;
                }

                var dynamicObjects = ((from p in innerConvertOperationResult.TargetDataEntities
                                       select p.DataEntity).ToArray<DynamicObject>());
                dynamicObject = dynamicObjects[0];
                billView.Model.DataObject = dynamicObject;
            }

            Save save = new Save();
            save.Initialize(new WebServiceContext(billView, null, null, new FormOperation()));
            try
            {
                save.Map(pushAndSaveArgs.Model, dynamicObject);
            }
            catch (KDException ex)
            {
                result.resultMsg = ex.Message;
                result.resultCode = "0001";
                billView.CommitNetworkCtrl();
                return result;
            }
            billView.CommitNetworkCtrl();

            if (pushAndSaveArgs.IsInTransaction)
            {
                using (SessionScope scope = new SessionScope())
                {
                    using (KDTransactionScope ts = new KDTransactionScope(TransactionScopeOption.Required))
                    {
                        result = SaveAndAudit(billView, billFormMetadata, isToAudit, isAutoSubmit);
                        if (result.resultCode == "0000")
                        {
                            ts.Complete();
                        }
                        return result;
                    }
                }
            }
            else
            {
                return SaveAndAudit(billView, billFormMetadata, isToAudit, isAutoSubmit);
            }

        }

        /// <summary>
        /// 保存提交审核
        /// </summary>
        /// <param name="billView"></param>
        private Result SaveAndAudit(IBillView billView, FormMetadata billFormMetadata, bool isToAudit, Ismode isAutoSubmit)
        {
            //0暂存
            //1保存
            //2保存提交
            //3保存提交审核
            Result result = new Result();
            OperateOption option = OperateOption.Create();
            option.SetNotShowConfirmInfo(true);
            option.SetIgnoreWarning(true);
            option.SetIgnoreInteractionFlag(true);
            List<object> successIds = new List<object>();
            IOperationResult saveResult = billView.Model.Save(option);


            //1保存
            //2保存提交
            //3保存提交审核
            if (isAutoSubmit == Ismode.save || isAutoSubmit == Ismode.submit || isAutoSubmit == Ismode.auto)
            {

                LoadSuccessIds(successIds, saveResult);
                GenMessages(result, saveResult, "保存", !isToAudit);
                if (successIds.Count == 0) return result;
                if (!isToAudit && result.resultCode == "0000")
                {
                    result.resultMsg = "同步成功";
                }
                if (isAutoSubmit == Ismode.save && result.resultCode == "0000"&& result.resultData.Count == 0)
                {
                    GenMessages(result, saveResult, "保存", true);
                    //result.resultMsg = "同步成功";
                }
            }
            if (isAutoSubmit == Ismode.submit || isAutoSubmit == Ismode.auto)
            {
                IOperationResult submitResult = BusinessDataServiceHelper.Submit(this.KDContext.Session.AppContext, billFormMetadata.BusinessInfo, successIds.ToArray(), FormOperationEnum.Submit.ToString());
                LoadSuccessIds(successIds, submitResult);
                GenMessages(result, submitResult, "提交");
                if (successIds.Count == 0) return result;
                if (isAutoSubmit == Ismode.submit && result.resultCode == "0000" && result.resultData.Count == 0)
                {
                    GenMessages(result, saveResult, "提交", true);
                   // result.resultMsg = "同步成功";
                }
            }

            if (isAutoSubmit == Ismode.auto)
            {
                IOperationResult auditResult = BusinessDataServiceHelper.Audit(this.KDContext.Session.AppContext, billFormMetadata.BusinessInfo, successIds.ToArray(), OperateOption.Create());
                LoadSuccessIds(successIds, auditResult);
                GenMessages(result, auditResult, "审核", true);
                if (result.resultCode == "0000" && result.resultData.Count == 0)
                {
                    GenMessages(result, saveResult, "审核", true);
                }
                if (result.resultCode == "0000")
                {
                    result.resultMsg = "同步成功";
                }
            }


            return result;
        }

        /// <summary>
        /// 根据结果生成返回消息
        /// </summary>
        /// <param name="curResult"></param>
        /// <param name="result"></param>
        /// <param name="type"></param>
        private void GenMessages(Result curResult, IOperationResult result, string type, bool isRecordSuccess = false)
        {
            var isSuccess = GenMessage(curResult, result, isRecordSuccess);
            curResult.performances.Add(new Performance() { stage = type, pointTime = DateTime.Now });
            curResult.resultCode = isSuccess ? "0000" : "0001";
            curResult.resultMsg = type + (isSuccess ? "成功" : "失败");
        }

        /// <summary>
        /// 根据结果生成返回消息明细
        /// </summary>
        /// <param name="curResult"></param>
        /// <param name="result"></param>
        private bool GenMessage(Result curResult, IOperationResult result, bool isRecordSuccess)
        {
            bool isSuccess = true;
            if (result.ValidationErrors != null)
            {
                foreach (ValidationErrorInfo errorInfo in result.ValidationErrors)
                {
                    string messageStr = errorInfo.Message.ToString();
                    ResultData resultData = new ResultData();
                    resultData.msg = messageStr;
                    curResult.resultData.Add(resultData);
                    isSuccess = false;
                }
            }
            if (result.OperateResult != null)
            {
                foreach (OperateResult opResult in result.OperateResult)
                {
                    if (opResult.SuccessStatus && isRecordSuccess)
                    {
                        if (string.IsNullOrWhiteSpace(opResult.Number)) continue;

                        ResultData resultData = new ResultData();
                        resultData.code = opResult.Number;
                        curResult.resultData.Add(resultData);
                    }
                    else if (!opResult.SuccessStatus)
                    {
                        string messageStr = opResult.Message.ToString();
                        ResultData resultData = new ResultData();
                        resultData.code = opResult.Number;
                        resultData.msg = messageStr;
                        curResult.resultData.Add(resultData);
                        isSuccess = false;
                    }
                }
            }

            if (result.InteractionContext != null)
            {
                string messageStr = result.InteractionContext.SimpleMessage;
                ResultData resultData = new ResultData();
                resultData.msg = messageStr;
                curResult.resultData.Add(resultData);
                isSuccess = false;
            }
            return isSuccess;
        }


        /// <summary>
        /// 加载成功的ID
        /// </summary>
        /// <param name="successIds"></param>
        /// <param name="result"></param>
        private void LoadSuccessIds(List<object> successIds, IOperationResult result)
        {
            successIds.Clear();
            if (result.OperateResult != null)
            {
                foreach (var operateResult in result.OperateResult)
                {
                    if (operateResult.SuccessStatus)
                    {
                        successIds.Add(operateResult.PKValue);
                    }
                }
            }
        }

    }
}


