﻿using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Util;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.IO;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;

namespace LQKJ.K3.MFG.PRD.App.ServicePlugIn
{
    [Description("销售出库单撤销插件"),HotUpdate ]
     public class SalOutStockBackOutPlugIn: Kingdee.K3.SCM.App.RPM.ServicePlugin.UpdateAccountBalancePlugin.CancelAssign
    {
        public override void BeforeExecuteOperationTransaction(BeforeExecuteOperationTransaction e)
        {
            base.BeforeExecuteOperationTransaction(e);
            try
            {
                var Url= Kingdee.BOS.KDConfiguration.Current.CommonConfiguration.AppSettings.Settings["CancelUrl"].Value;
                HttpWebRequest Request = (HttpWebRequest)WebRequest.Create(Url);
                Request.Method = "POST";
                Request.ContentType = "application/json";
                Stream RequestStream = Request.GetRequestStream();
                StreamWriter myStreamWrite = new StreamWriter(RequestStream, Encoding.GetEncoding("utf-8"));
                var entity = e.SelectedRows;
                StringBuilder stringBuilder = new StringBuilder();
                string Json = "{\"numbers\":[";
                stringBuilder.Append(Json);
                string Id = "";
                foreach (var item in entity)
                {
                     Id = "\""+item.DataEntity["BillNo"] +"\"";
                    stringBuilder.Append(Id + ",");
                }
                stringBuilder.Remove(stringBuilder.Length-1,1 );
                stringBuilder.Append("]}");
                myStreamWrite.Write(stringBuilder.ToString());
                myStreamWrite.Flush();
                HttpWebResponse Response = (HttpWebResponse)Request.GetResponse();
                if (Response.StatusCode == HttpStatusCode.OK)
                {
                    Stream ResponseStream = Response.GetResponseStream();
                    StreamReader StreamReader = new StreamReader(ResponseStream, Encoding.GetEncoding("utf-8"));
                    string retString = StreamReader.ReadToEnd();
                    JObject obj = JObject.Parse(retString);
                    ResponseStream.Close();
                    StreamReader.Close();
                    if (obj["message"].ToString() != "可撤销")
                    {
                        e.CancelMessage = $"单据编号为“{Id}”的销售出库单，撤销失败！";
                        e.Cancel = true;
                    }
                }
            }
            catch (Exception ex)
            {
                throw ex;
            } 
        }
    }
}
