﻿using Kingdee.BOS.Contracts;
using Kingdee.BOS.Core.Const;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Core.Metadata;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.ServiceHelper;
using Kingdee.BOS.Util;
using Kingdee.BOS.Workflow.Interface;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LQKJ.K3.MFG.PRD.App.ServicePlugIn
{
    [Description("销售出库审核服务插件"),HotUpdate]
   public class SalOutStockServicePlugin: Kingdee.K3.SCM.App.Sal.ServicePlugIn.OutStock.Audit
    {
        public override void BeforeExecuteOperationTransaction(BeforeExecuteOperationTransaction e)
        {
            //审核事务开始前的操作
            base.BeforeExecuteOperationTransaction(e);
            if (this.Context.ClientType == Kingdee.BOS.ClientType.WebApi)
            {
                var entity = e.SelectedRows;
                StringBuilder stringBuilder = new StringBuilder();
                string startSql= $@"select * from v_wf_PMAssign a left join V_WF_PMASSIGN_L b on a.FASSIGNID=b.FASSIGNID 
                                    and FLOCALEID=2052
                                    where FOBJECTTYPEID = 'SAL_OUTSTOCK' and fbillnumber in ('666'";
                stringBuilder.Append(startSql);
                foreach (var item in entity)
                {

                    var BillNo = item.DataEntity["BillNo"];
                    string Middle = $@",'{BillNo}'";
                    stringBuilder.Append(Middle);
                }
                string endSql = $@")and FASSIGNNAME!='终审节点' and FSTATUS!=1";//流程不是终审节点,并且上一级节点还没走完
                stringBuilder.Append(endSql);
                DataTable dataTable = DBServiceHelper.ExecuteDataSet(this.Context, stringBuilder.ToString()).Tables[0];
                if (dataTable.Rows.Count > 0)
                {
                    var Message = "以下单据不满足审核条件：";
                    for (int i = 0; i < dataTable.Rows.Count; i++)
                    {
                        Message += dataTable.Rows[i]["fbillnumber"].ToString()+",";
                    }
                    e.CancelMessage = Message;
                    e.Cancel = true;//阻止审核继续下去
                }
            }
        }
    }
}
