﻿using Kingdee.BOS;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Contracts;
using Kingdee.BOS.Core;
using Kingdee.BOS.Core.DynamicForm;
using Kingdee.BOS.Core.DynamicForm.Operation;
using Kingdee.BOS.Core.List;
using Kingdee.BOS.Core.Metadata;
using Kingdee.BOS.Core.Metadata.ConvertElement;
using Kingdee.BOS.Core.Metadata.ConvertElement.ServiceArgs;
using Kingdee.BOS.Log;
using Kingdee.BOS.Orm;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.ServiceHelper;
using Kingdee.K3.MFG.Contracts.PRD;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Transactions;
using LQKJ.K3.MFG.PRD.App.ServicePlugIn;

namespace LQKJ.K3.MFG.PRD.App.ServicePlugIn
{
    [Kingdee.BOS.Util.HotUpdate]
    [Description("自动推送缺料分析  计算服务")]
    public class ShortageAnalysisService : IScheduleService
    {
        private Context context;
        AnalysisResults analysis = new AnalysisResults();
        public void Run(Context ctx, Schedule schedule)
        {
            context = ctx;
            AnalysisShortage(ctx);
        }
        /// <summary>
        /// 自动缺料分析
        /// </summary>
        /// Automatic自动
        /// Manual手动
        private void AnalysisShortage(Context ctx)
        {
            analysis.LackAnalyse(ctx, "Automatic");
        }
    }
}
