﻿using Kingdee.BOS;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Core.List.PlugIn;
using Kingdee.BOS.App.Data;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using LQKJ.K3.MFG.PRD.App.ServicePlugIn;
using System.Data;
using Kingdee.BOS.ServiceHelper;
using Kingdee.BOS.Contracts;
using Kingdee.BOS.Orm;
using Kingdee.BOS.Core.DynamicForm;
using Kingdee.BOS.Core.Metadata;
using Newtonsoft.Json.Linq;
using Kingdee.BOS.Core;
using Kingdee.BOS.KDThread;
using System.Threading;
using Kingdee.BOS.Log;
using Newtonsoft.Json;
using System.Transactions;
using Kingdee.BOS.Core.Metadata.ConvertElement;
using Kingdee.BOS.Core.Metadata.ConvertElement.ServiceArgs;
using Kingdee.BOS.Core.DynamicForm.Operation;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.Core.List;

namespace LQKJ.K3.MFG.PRD.BusinessPlugIn
{
    [Kingdee.BOS.Util.HotUpdate]
    [Description("手动推送缺料分析匹配结果")]
    public class PushMESPlugin : AbstractListPlugIn
    {
        AnalysisResults analysis = new AnalysisResults();
        public override void BarItemClick(BarItemClickEventArgs e)
        {
            if (e.BarItemKey == "LQKJ_tbButton")
            {
                AnalysisShortage(this.Context);
            }
            base.BarItemClick(e);
        }

        /// <summary>
        /// 自动缺料分析
        /// </summary>
        /// Automatic自动
        /// Manual手动
        /// 手动需启用进度条，自动不需要
        public void AnalysisShortage(Context ctx)
        {
            Logger.Info("缺料分析", "开始异步同步");
            this.View.ShowProcessForm(formResult => { }, true, "正在分析数据中...");
            // 启动线程执行耗时操作，同时更新执行进度     
            MainWorker.QuequeTask(this.View.Context, () =>
            {
                try
                {
                    analysis.LackAnalyse(ctx, "Manual",this.View);
                }
                catch (Exception ex) { this.View.ShowErrMessage(ex.Message); }
                finally
                {
                    // 此句必不可少，进度值100时进度条自动关闭   
                    this.View.Session["ProcessRateValue"] = 100;
                    this.View.SendDynamicFormAction(this.View);

                    Logger.Info("缺料分析", "结束异步同步");
                }
            }, null);
        }

       
    }
}
