﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Kingdee.BOS;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core;
using Kingdee.BOS.Core.DynamicForm;
using Kingdee.BOS.Core.DynamicForm.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Core.List.PlugIn;
using Kingdee.BOS.Core.Validation;
using Kingdee.BOS.ServiceHelper;
using Kingdee.BOS.Util;
using System.Data;
using System.Dynamic;
using System.ComponentModel;

namespace LF.K3.SCM.AppServerPlugin.AuditChecks
{
    [Description("校验器")]
    [HotUpdate]
    public class AuditCheckPlugIn : AbstractValidator
    {
        public override void Validate(ExtendedDataEntity[] dataEntities, ValidateContext validateContext, Context ctx)
        {
            if (validateContext.IgnoreWarning)
            {
                return; // 警告已经被用户忽略，就不需要再次执行了
            }
            if (dataEntities == null || dataEntities.Length <= 0)
            {
                return;
            }
            DataTable dt = null;
            ExtendedDataEntity[] a = dataEntities;
            string BillNo = string.Empty;
            foreach (var item in dataEntities)
            {
                BillNo = item.BillNo;
            }
            //获取子项BOM
            string sql = "select * from T_ENG_BOM where FMATERIALID in(select FMATERIALID from T_ENG_BOMCHILD where FID=(select fid from T_ENG_BOM  where FNUMBER='" + BillNo + "'))";
            dt = DBUtils.ExecuteDataSet(this.Context, sql).Tables[0];
            if (dt==null||dt.Rows.Count<=0)
            {
                return;
            }
            string js = "";
            int index = 0;
            
            // 循环校验每一个数据包（一个数据包对应一张单据）
            foreach (var et in dataEntities)
            {
                //判断是否为BOM，不是BOM跳过此次循环
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    //物料清单: FMATERIALID父项物料id
                    if (et.DataEntity[3].ToString() == dt.Rows[i]["FMATERIALID"].ToString()) 
                    {
                        js = "";
                        break;
                    }
                    else
                    {
                        js = "跳过";
                    }
                }
                if (js== "跳过") continue;

                string zt = dt.Rows[index]["FDocumentStatus"].ToString();
                index++;
                //如果校验不通过，抛出校验异常
                if (zt != "C")
                {
                    validateContext.AddError(et, new ValidationErrorInfo(
                     "",//出错的字段key，可以空
                     Convert.ToString(et.DataEntity[0]),//数据包内码，必填，后续操作会据此内码避开此数据包
                     et.DataEntityIndex,
                     et.RowIndex,
                     "E1",
                     "子项BOM有未审核状态",
                     "审核:"+et.BillNo,
                     ErrorLevel.FatalError
                     )
                     );
                }
            }

        }
    }
    [Description("BOM审核校验")]
    [HotUpdate]
    public class AuditCheck : AbstractOperationServicePlugIn
    {
        //public override void OnPreparePropertys(PreparePropertysEventArgs e)
        //{
        //    base.OnPreparePropertys(e);
        //    //加载父级物料编码
        //    e.FieldKeys.Add("FNUMBER");
        //}

        //
        public override void OnAddValidators(AddValidatorsEventArgs e)
        {
            base.OnAddValidators(e);
            AuditCheckPlugIn auditcheck = new AuditCheckPlugIn();
            //是否需要校验，true需要
            auditcheck.AlwaysValidate = true;
            //校验单据体
            auditcheck.EntityKey = "FTreeEntity";
            //加载校验器
            e.Validators.Add(auditcheck);
        }
    }
}
