﻿using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core.DynamicForm.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.Util;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;

namespace LF.K3.SCM.AppServerPlugin.ChangeReceiveDate
{
    [HotUpdate]
    [Description("签收日期变更单审核")]
    public class UnAudit : AbstractOperationServicePlugIn
    {
        const string sql = "update T_SAL_OUTSTOCK set F_QAZ_ARRIVALTIME = '{0}' where FBILLNO = '{1}' ";
        public override void OnPreparePropertys(PreparePropertysEventArgs e)
        {
            e.FieldKeys.Add("F_qaz_outStock");
            e.FieldKeys.Add("F_qaz_arrivalTimeBC");
            base.OnPreparePropertys(e);
        }

        public override void BeginOperationTransaction(BeginOperationTransactionArgs e)
        {
            List<string> sqls = new List<string>();

            foreach (DynamicObject data in e.DataEntitys)
            {
                var entry = data["qaz_ChangeReceiveDEntry"] as DynamicObjectCollection;
                foreach (var entryData in entry)
                {
                    var outStockNo = entryData["F_qaz_outStock"] as string;
                    var arrivalTimeBC = entryData["F_qaz_arrivalTimeBC"];
                    sqls.Add(string.Format(sql, arrivalTimeBC == null ? "": arrivalTimeBC, outStockNo));
                }
            }

            DBUtils.ExecuteBatch(this.Context, sqls, sqls.Count);
            base.BeginOperationTransaction(e);

        }
    }
}
