﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Kingdee.BOS.Core.Bill.PlugIn;
using Kingdee.BOS.Core.Metadata.FieldElement;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.Orm.Metadata.DataEntity;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using System.ComponentModel;
using Kingdee.BOS.Util;
using System.Data;
using Kingdee.BOS.Core.Metadata.EntityElement;
using Kingdee.BOS.Core.List.PlugIn;
using Kingdee.BOS.Core.List;
using Kingdee.BOS.App.Data;

namespace LF.K3.SCM.BusinessPlugin
{
    [Description("干预套打数据")]
    [HotUpdate]
    public class BOMPrintPlugin : AbstractBillPlugIn
    {
        public override void OnPrepareNotePrintData(PreparePrintDataEventArgs e)
        {
            if (e.DataSourceId == "FTreeEntity")
            {
                DynamicObject[] qureyObjs = e.DataObjects;
                DynamicObject tra = new DynamicObject(e.DynamicObjectType);
                List<DynamicObject> result = new List<DynamicObject>();
                DataTable dt = null;
                //动态字段注册
                DynamicObjectType dot = e.DataObjects[0].DynamicObjectType;
                dot.RegisterSimpleProperty(
                "bh",
                typeof(object),
                attributes: new SimplePropertyAttribute() { Alias = "bh" }
                 );
                for (int i = 0; i < qureyObjs.Length; i++)
                {
                    DynamicObject obj = new DynamicObject(dot);
                    foreach (var p in e.DataObjects[i].DynamicObjectType.Properties)
                    {
                        obj[p] = e.DataObjects[i][p];
                    }
                    obj["bh"] = obj["FTreeEntity_FSEQ"];
                    e.DataObjects[i] = obj;
                }


                for (int i = 0; i < qureyObjs.Length; i++)
                {
                    result.Add(qureyObjs[i]);
                    //string sql = @"select * from (select * from T_ENG_BOMCHILD where FID=(select MAX(FID) FID from T_ENG_BOM where FMATERIALID=(select FMATERIALID from T_BD_MATERIAL where FNUMBER='" + qureyObjs[i]["FMATERIALIDCHILD_FNumber"].ToString() + "'))) a LEFT JOIN  T_BD_MATERIAL b on a.FMATERIALID = b.FMATERIALID LEFT JOIN  T_BD_MATERIAL_L c on b.FMATERIALID = c.FMATERIALID";
                    string sql = string.Format(@"select * from (select * from T_ENG_BOMCHILD where FID=(select MAX(FID) FID from T_ENG_BOM 
                                              where FMATERIALID = (select FMATERIALID from T_BD_MATERIAL where FNUMBER = '{0}'))) a
                                              LEFT JOIN T_BD_MATERIAL b on a.FMATERIALID = b.FMATERIALID LEFT JOIN  T_BD_MATERIAL_L c on b.FMATERIALID = c.FMATERIALID
                                              LEFT JOIN  T_ENG_BOMCHILD_l d on a.FENTRYID = d.FENTRYID", qureyObjs[i]["FMATERIALIDCHILD_FNumber"].ToString());
                    dt = DBUtils.ExecuteDataSet(this.Context, sql).Tables[0];
                    if (dt == null) continue;


                    for (int j = 0; j < dt.Rows.Count; j++)
                    {
                        if (dt.Rows.Count > 0)
                        {
                            tra["FID"] = dt.Rows[j]["FID"].ToString();
                            //tra["FReplaceGroup"]= dt.Rows[j]["FReplaceGroup"].ToString();
                            tra["FCHILDUNITID_U"] = "0";
                            tra["FNUMERATOR"] = dt.Rows[j]["FNUMERATOR"].ToString();
                            //tra["FActualQty"] = dt.Rows[j]["FActualQty"].ToString();
                            tra["FPOSITIONNO"] = dt.Rows[j]["FPOSITIONNO"].ToString();
                            tra["FMATERIALIDCHILD_Id"] = dt.Rows[j]["FMATERIALID"].ToString();
                            //tra["FMATERIALIDCHILD_Ref"] = "MATERIAL";
                            tra["FCHILDUNITID_Id"] = dt.Rows[j]["FUNITID"].ToString();
                            //tra["FCHILDUNITID_Ref"] = "UNIT";
                            tra["FENTRYID"] = dt.Rows[j]["FENTRYID"].ToString();
                            tra["FTreeEntity_FSEQ"] = dt.Rows[j]["FSEQ"].ToString();
                            tra["FUseOrgId"] = "1";
                            tra["FMATERIALIDCHILD_FNumber"] = dt.Rows[j]["FNUMBER"].ToString();
                            tra["FMATERIALIDCHILD_FName"] = dt.Rows[j]["FNAME"].ToString();
                            tra["FMATERIALIDCHILD_FSpecification"] = dt.Rows[j]["FSpecification"].ToString();
                            tra["FCHILDUNITID_FName"] = "Pce";
                            tra["FMEMO"] = dt.Rows[j]["FMEMO"].ToString();
                            tra["bh"] = qureyObjs[i]["bh"].ToString() + "." + dt.Rows[j]["FSEQ"].ToString();
                            result.Add(tra);
                            tra = new DynamicObject(e.DynamicObjectType);
                        }
                    }

                }
                Kingdee.BOS.ServiceHelper.DBServiceHelper.LoadReferenceObject(this.Context, result.ToArray(), e.DynamicObjectType);
                e.DataObjects = result.ToArray();
                //DynamicObject a = e.DataObjects[0].DynamicObjectType.CreateInstance() as DynamicObject;
            }
            base.OnPrepareNotePrintData(e);
        }
    }
}
