﻿using Kingdee.BOS;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core.DynamicForm;
using Kingdee.BOS.Core.DynamicForm.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Core.DynamicForm.PlugIn.ControlModel;
using Kingdee.BOS.Core.List.PlugIn;
using Kingdee.BOS.Core.List.PlugIn.Args;
using Kingdee.BOS.Core.Metadata.EntityElement;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.ServiceHelper;
using Kingdee.BOS.Util;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Dynamic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Transactions;

namespace LF.K3.SCM.BusinessPlugin
{
    [Description("打开物料替换弹出框")]
    [HotUpdate]
    public class GGReplaceModel : AbstractDynamicFormPlugIn
    {
        DataTable dt;
        public override void AfterBindData(EventArgs e)
        {
            base.AfterBindData(e);
            //禁用替换按钮
            this.Enablecontrol("F_qaz_Button1", false);
            this.Enablecontrol("F_qaz_Text1", false);
            //获取传入的值
            string billno = this.View.OpenParameter.GetCustomParameter("billno").ToString();
            billno = billno.Remove(billno.LastIndexOf(","));//截断字符
            //查询数据
            string sql = $@"/*dialect*/select FNUMBER FNUMBER,FNAME FNAME,F_QAZ_REMARK F_FRONT from t_BD_MATERIAL T0  
                left join T_BD_MATERIAL_L T1  on T0.FMATERIALID=T1.FMATERIALID  WHERE T0.FMATERIALID IN ({billno}) ";
            DataSet ds = DBServiceHelper.ExecuteDataSet(this.Context, sql);
            dt = ds.Tables[0];
            //绑定在单据体中
            this.Model.BatchCreateNewEntryRow("F_qaz_Entity", dt.Rows.Count - 1);
            var aaa = dt.Rows[0]["FNUMBER"].ToString() + dt.Rows[0]["FNAME"].ToString() + dt.Rows[0]["F_FRONT"].ToString();
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                this.View.Model.SetValue("FNUMBER", dt.Rows[i]["FNUMBER"].ToString(), i);
                this.View.Model.SetValue("FNAME", dt.Rows[i]["FNAME"].ToString(), i);
                this.View.Model.SetValue("F_FRONT", dt.Rows[i]["F_FRONT"].ToString(), i);
            }
            this.View.UpdateView("F_qaz_Entity");
        }
        //自定义方法,按钮是否可用控制
        //private void EnableButton(string key, bool bEnable)
        //{
        //    this.View.GetControl<Button>(key).Enabled = bEnable;
        //}
        private void Enablecontrol(string key, bool bEnable)
        {
            this.View.GetControl(key).Enabled = bEnable;
        }
        public override void BeforeDoOperation(BeforeDoOperationEventArgs e)
        {
            //查找规格
            if (e.Operation.FormOperation.Id == "F_qaz_Button")
            {
                if (this.Model.GetValue("F_qaz_Text").ToString() == "")
                {
                    this.View.ShowWarnningMessage("需替换掉的规格，不能为空");
                }
                else
                {
                    string bm = SelectData();
                    if (bm == "")
                    {
                        this.View.ShowMessage("需替换规格的所有物料存在此规格，可以开始进行替换");
                        this.Enablecontrol("F_qaz_Button", false);
                        this.Enablecontrol("F_qaz_Button1", true);
                        this.Enablecontrol("F_qaz_Text", false);
                        this.Enablecontrol("F_qaz_Text1", true);
                    }
                    else
                    {
                        this.View.ShowWarnningMessage("物料编码：" + bm.Remove(bm.LastIndexOf(",")) + "不存在此规格，暂不能进行替换");

                    }
                }

            }
            //开始替换
            if (e.Operation.FormOperation.Id == "F_qaz_Button1")
            {
                if (this.Model.GetValue("F_qaz_Text1").ToString() == "")
                {
                    this.View.ShowWarnningMessage("需替换成的规格，不能为空");
                }
                else
                {
                    replace();
                }

            }
        }

        //查找数据
        public string SelectData()
        {
            string msg = this.Model.GetValue("F_qaz_Text").ToString();
            //this.View.ShowMessage(msg);
            string BM = "";
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                string gg = dt.Rows[i]["F_FRONT"].ToString();
                List<string> strlist = new List<string>();
                char[] aa = new char[3];
                aa[0] = '，';
                aa[1] = ',';
                aa[2] = '。';
                strlist = gg.Split(aa).ToList();
                //查找是否存在此字符
                bool iscz = strlist.Contains(msg);
                if (!iscz)
                {
                    BM += dt.Rows[i]["FNUMBER"] + ",";
                }
            }
            return BM; ;
        }
        //替换
        public bool replace()
        {
            string front = this.Model.GetValue("F_qaz_Text").ToString();
            string after = this.Model.GetValue("F_qaz_Text1").ToString();

            var entity = this.View.BillBusinessInfo.GetEntity("F_qaz_Entity");
            var entityObjs = this.View.Model.GetEntityDataObject(entity);
            string str = "";
            List<string> list = new List<string>();
            if (entityObjs != null)
            {
                foreach (var entityObj in entityObjs)
                {
                    // 遍历单据体数据        
                    str += entityObj["FNUMBER"].ToString() + ",";
                    string strth = entityObj["F_FRONT"].ToString();
                    strth = strth.Replace(front, after);
                    list.Add(strth);
                    var expression = "/^"+ after + "(,|，|。)[\S]/";
                    Regex regex = new Regex("/^" + after + "(,|，|。)\S/");
                    Regex regex1 = new Regex("/^.(,|，|。)"+ after + "$");
                    var aa= regex.IsMatch(strth);
                    var bb = regex1.IsMatch(strth);

                }
            }
            else
            {
                //List<SqlObject> sqllist = new List<SqlObject>();
                //string sql = "";
                //sqllist.Add(new SqlObject(sql,new List<SqlParam>()));
                //using (KDTransactionScope scope = new KDTransactionScope(TransactionScopeOption.Required))
                //{
                //    DBUtils.ExecuteBatch(this.Context, sqllist);
                //    scope.Complete();
                //}
            }


            return true;
        }

    }
}
