﻿using Kingdee.BOS;
using Kingdee.BOS.App;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Contracts;
using Kingdee.BOS.Core.CommonFilter;
using Kingdee.BOS.Core.DynamicForm.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Core.DynamicForm.PlugIn.ControlModel;
using Kingdee.BOS.Core.List.PlugIn;
using Kingdee.BOS.Core.Metadata.FieldElement;
using Kingdee.BOS.JSON;
using Kingdee.BOS.ServiceHelper;
using Kingdee.BOS.ServiceHelper.Excel;
using Kingdee.BOS.Util;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;

namespace LF.K3.SCM.BusinessPlugin
{
    [Description("上传excel")]
    [HotUpdate]
    public class ImportDatePlugin : AbstractDynamicFormPlugIn
    {
        DataTable dtexcel;
        private string _filePath;
        int CFnum;
        int Excelsum;
        int jg;
        public override void BeforeDoOperation(BeforeDoOperationEventArgs e)
        {

            if (e.Operation.FormOperation.Id == "FImportDate")
            {
                if (this.IsNotNull())
                {
                    //数据的操作
                    Impoort();
                    if (jg == -1)
                    {
                        this.View.ShowWarnningMessage("导入失败");
                    }
                    else
                    if (CFnum > 0)
                    {
                        this.View.ShowWarnningMessage("excel中存在" + CFnum + "条重复物料," + (Excelsum - CFnum) + "条物料导入新增成功");
                        
                        this.View.Refresh();
                    }
                    else
                    {
                        this.View.ShowMessage("物料导入成功");
                        this.View.Refresh();
                    }

                }
            }
        }
        public override void AfterBindData(EventArgs e)
        {
            this.EnableButton("FImportDate", false);
            base.AfterBindData(e);
        }

        //自定义方法,判断是否上传Excel表格
        private bool IsNotNull()
        {
            ExcelOperation excelOperation = new ExcelOperation();
            DataSet dataSet = null;
            dataSet = excelOperation.ReadFromFile(this._filePath, 0, 0);
            dtexcel = dataSet.Tables["Sheet1"];
            if (dtexcel == null)
            {
                this.View.ShowWarnningMessage("没有找到模板请重新选择");
                return false;
            }
            return true;
        }


        public override void CustomEvents(CustomEventsArgs e)
        {
            if (e.Key.EqualsIgnoreCase("FFileUpdate"))
            {
                this.View.GetControl("FFileUpdate").SetCustomPropertyValue("NeedCallback", true);
                this.View.GetControl("FFileUpdate").SetCustomPropertyValue("IsRequesting", false);
                if (e.EventName.EqualsIgnoreCase("FileChanged"))
                {
                    var postData = KDObjectConverter.DeserializeObject<JSONObject>(e.EventArgs);

                    if (postData == null)
                    {
                        this.View.ShowWarnningMessage("未选择文件！");
                    }
                    else
                    {
                        var uploadInfo = new JSONArray(postData["NewValue"].ToString());
                        if (uploadInfo.Count == 1)
                        {
                            // 取上传的文件名
                            var fileInfo = uploadInfo[0] as Dictionary<string, object>;
                            if (fileInfo != null)
                            {
                                var fileName = fileInfo["ServerFileName"].ToString();
                                if (this.CheckFile(fileName))
                                {
                                    //上传完成
                                    this._filePath = this.GetFilePath(fileName);
                                    this.EnableButton("FImportDate", true);
                                }
                                else
                                {
                                    //上传文件格式不正确
                                    this.EnableButton("FImportDate", false);
                                }
                            }
                        }
                        else
                         //只允许上传一个文件
                         if (uploadInfo.Count > 1)
                        {
                            this.EnableButton("FImportDate", false);
                            this.View.ShowWarnningMessage("只允许上传一个文件！");
                        }
                    }
                }

            }
        }
        //自定义方法,引入的数据
        private void Impoort()
        {
            ExcelOperation excelOperation = new ExcelOperation();
            DataSet dataSet = null;
            dataSet = excelOperation.ReadFromFile(this._filePath, 0, 0);
            DataTable dt = dataSet.Tables[0];
            string strTest = GetCreateTmpTableNameSql(dt.Columns);//获取Excel列
            //截取sql表列
            strTest = strTest.Substring(1, strTest.Length - 1);
            strTest = strTest.Remove(strTest.Length - 1, 1);
            //判断是否存在此表，如果存在则删除
            string sql2 = $@"/*dialect*/ IF Object_id('LStable') IS NOT NULL DROP TABLE LStable";
            var a=DBUtils.Execute(this.Context, sql2);
            //创建表
            string sql1 = "create table LStable(" + strTest;
            DBUtils.Execute(this.Context, sql1);
            //移除datatable中的第一行（第一行数据为Excel中的列字段信息）
            dt.Rows.RemoveAt(0);
            //表名匹配
            dt.TableName = "LStable";
            //Excel数据批量导入表中
            DBServiceHelper.BulkInserts(this.Context, string.Empty, string.Empty, dt);
            //定义输出参数
            int num = 0; string xznum = "";
            SqlParam sqlParam1 = new SqlParam("@num", KDDbType.Int16, num);
            SqlParam sqlParam2 = new SqlParam("@xznum", KDDbType.String, xznum);
            sqlParam1.Direction = ParameterDirection.Output;
            sqlParam2.Direction = ParameterDirection.Output;
            List<SqlParam> sqlParams = new List<SqlParam>();
            sqlParams.Add(sqlParam1);
            sqlParams.Add(sqlParam2);
            //执行存储过程
            var result = DBUtils.ExecuteStoreProcedure(this.Context, "ImportData", sqlParams);
            if (result.Count > 0)
            {
                Excelsum = dt.Rows.Count;
                CFnum = Convert.ToInt32(result[0].Value);//重复物料
                jg = Convert.ToInt32(result[1].Value);//最后结果
            }
            else
            {
                jg = -1;
            }
            //删除表
            string sql3 = "DROP TABLE LStable";
            DBUtils.Execute(this.Context, sql3);
        }
        //自定义方法,拼接临时表字段
        private string GetCreateTmpTableNameSql(DataColumnCollection fieldColumn)
        {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.AppendLine("(");
            List<string> listStr = new List<string>();
            foreach (var field in fieldColumn)
            {
                listStr.Add('"' + Convert.ToString(field).Trim().ToString() + '"' + " nvarchar(1000)");
            }
            stringBuilder.AppendLine(String.Join(",", listStr.Distinct()));
            stringBuilder.AppendLine(")");
            return stringBuilder.ToString();
        }
        //自定义方法,判断是否是上传的是Excel文件
        private bool CheckFile(string fileName)
        {
            bool flag = false;
            string[] array = fileName.Split(new char[] { '.' });
            //通过后缀名,判断是否是Excel
            if (array.Length == 2 && (array[1].EqualsIgnoreCase("xls") || array[1].EqualsIgnoreCase("xlsx")))
            {
                flag = true;
            }
            if (!flag)
            {
                this.View.ShowWarnningMessage("请选择正确的文件格式进行引入");
            }
            return flag;
        }

        //自定义方法,没有上传完成Excel,那么上传按钮是灰色的
        private void EnableButton(string key, bool bEnable)
        {
            this.View.GetControl<Button>(key).Enabled = bEnable;
        }
        //获取上传路径
        private string GetFilePath(string serverFileName)
        {
            string directory = "FileUpLoadServices\\UploadFiles";
            return PathUtils.GetPhysicalPath(directory, serverFileName);
        }




    }
}
