﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Kingdee.BOS.Core.List.PlugIn;
using Kingdee.BOS.Core.DynamicForm;
using System.ComponentModel;
using Kingdee.BOS.Util;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Core.List;
using System.Dynamic;

namespace LF.K3.SCM.BusinessPlugin
{
    [Description("物料编码导入功能")]
    [HotUpdate]
    public class ImportExcelPlugin : AbstractListPlugIn
    {
        public override void BarItemClick(BarItemClickEventArgs e)
        {
            base.BarItemClick(e);

            if (e.BarItemKey == "btn_daoru")
            {
                //显示动态表单
                DynamicFormShowParameter forParameter = new DynamicFormShowParameter();

                //获取动态表单的唯一标识
                forParameter.FormId = "qaz_uploadFile";

                this.View.ShowForm(forParameter);
            }
            if (e.BarItemKey == "btn_tbReplace")
            {
               
                var lv = this.View as IListView; 
                if (lv == null) { return; }
                string billno = "";
                var selectedRows = lv.SelectedRowsInfo;
                if (selectedRows == null || selectedRows.Count == 0) 
                { 
                    this.View.ShowMessage("当前没有行被选中！"); 
                    return;
                }
                else
                {
                   
                    for (int i = 0; i < selectedRows.Count; i++)
                    {
                        billno+= selectedRows[i].PrimaryKeyValue.ToString()+",";
                    }
                }

                //DynamicFormShowParameter forParameter = new DynamicFormShowParameter();
                ////获取动态表单的唯一标识
                //forParameter.FormId = "qaz_GGReplace";
                //forParameter.CustomComplexParams.Add("billno", billno);
                //this.View.ShowForm(forParameter);

                DynamicFormShowParameter dynamicFormShowParameter =new DynamicFormShowParameter();
                dynamicFormShowParameter.FormId = "qaz_GGReplace";
                dynamicFormShowParameter.CustomParams.Add("billno", billno);
                this.View.ShowForm(dynamicFormShowParameter);
                this.View.ReturnToParentWindow(dynamicFormShowParameter);



            }
        }

    }
}
