﻿using Kingdee.BOS.Core.Warn.PlugIn;
using Kingdee.BOS.Core.Warn.PlugIn.Args;
using Kingdee.BOS.Util;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;

namespace LF.K3.SCM.BusinessPlugin
{
    [HotUpdate]
    [Description("末次出库监控插件")]
    public class LastOutWarningPlugin: AbstractWarnServicePlugIn
    {
        public override void AfterWarnConditionParse(AfterWarnConditionParseArgs e)
        {
            string text = " exists (select 1 from T_SAL_OUTSTOCK T1 where T1.F_QAZ_ISLASTOUT = '1' and T0.FID > T1.FID and T0.F_QAZ_ASSISTANT1 = T1.F_QAZ_ASSISTANT1) and T0.F_QAZ_ISLASTOUT = '0' ";
            if (string.IsNullOrWhiteSpace(e.Filter))
            {
                e.Filter = text;
            }
            else
            {
                e.Filter = " and " + text;
            }
            base.AfterWarnConditionParse(e);
        }
    }
}
