﻿using Kingdee.BOS.Core.Bill.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Util;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;

namespace LF.K3.SCM.BusinessPlugin
{
    [HotUpdate]
    [Description("收款条件表单插件")]
    public class RecConditionEditPlugin : AbstractBillPlugIn
    {
        public override void DataChanged(DataChangedEventArgs e)
        {
            ComputeSendAllRate(e.Field.Key);
            ComputeAllRate1(e.Field.Key);
            ComputeAllRate2(e.Field.Key);
            ComputeLastRate(e.Field.Key);
            ComputeLastRate44(e.Field.Key);
            ComputeRate1(e.Field.Key, e.Row);
            ComputeRate2(e.Field.Key, e.Row);
            ComputeDay1(e.Field.Key, e.Row);
            ComputeDay2(e.Field.Key, e.Row);
            ComputeDate(e.Field.Key, e.Row);
            base.DataChanged(e);
        }

        /// <summary>
        /// 计算发货款总比例
        /// </summary>
        /// <param name="fieldKey"></param>
        private void ComputeSendAllRate(string fieldKey)
        {
            if (fieldKey != "F_qaz_PrePayRate" && fieldKey != "F_qaz_SendRate") return;

            decimal prePayRate = Convert.ToDecimal(this.Model.GetValue("F_qaz_PrePayRate"));
            decimal sendRate = Convert.ToDecimal(this.Model.GetValue("F_qaz_SendRate"));

            this.Model.SetValue("F_qaz_SendAllRate", prePayRate + sendRate);
        }


        /// <summary>
        /// 计算发货款总比例
        /// </summary>
        /// <param name="fieldKey"></param>
        private void ComputeAllRate1(string fieldKey)
        {
            if (fieldKey != "F_qaz_PrePayRate" && fieldKey != "F_qaz_SendRate" && fieldKey != "F_qaz_Rate1") return;

            decimal prePayRate = Convert.ToDecimal(this.Model.GetValue("F_qaz_PrePayRate"));
            decimal sendRate = Convert.ToDecimal(this.Model.GetValue("F_qaz_SendRate"));
            decimal rate1 = Convert.ToDecimal(this.Model.GetValue("F_qaz_Rate1"));

            this.Model.SetValue("F_qaz_AllRate1", prePayRate + sendRate + rate1);
        }


        /// <summary>
        /// 计算发货款总比例
        /// </summary>
        /// <param name="fieldKey"></param>
        private void ComputeAllRate2(string fieldKey)
        {
            if (fieldKey != "F_qaz_PrePayRate" && fieldKey != "F_qaz_SendRate" && fieldKey != "F_qaz_Rate1" && fieldKey != "F_qaz_Rate2") return;

            decimal prePayRate = Convert.ToDecimal(this.Model.GetValue("F_qaz_PrePayRate"));
            decimal sendRate = Convert.ToDecimal(this.Model.GetValue("F_qaz_SendRate"));
            decimal rate1 = Convert.ToDecimal(this.Model.GetValue("F_qaz_Rate1"));
            decimal rate2 = Convert.ToDecimal(this.Model.GetValue("F_qaz_Rate2"));

            this.Model.SetValue("F_qaz_AllRate2", prePayRate + sendRate + rate1 + rate2);
        }

        /// <summary>
        /// 计算剩余比例
        /// </summary>
        /// <param name="fieldKey"></param>
        private void ComputeLastRate44(string fieldKey)
        {
            var payWay = this.Model.GetValue("F_qaz_PayWay") as string;

            if (payWay != "4") return;
            if (fieldKey != "F_qaz_Rate") return;

            decimal prePayRate = Convert.ToDecimal(this.Model.GetValue("F_qaz_PrePayRate"));
            decimal sendRate = Convert.ToDecimal(this.Model.GetValue("F_qaz_SendRate"));
            decimal rate1 = Convert.ToDecimal(this.Model.GetValue("F_qaz_Rate1"));
            decimal rate2 = Convert.ToDecimal(this.Model.GetValue("F_qaz_Rate2"));

            this.Model.SetValue("F_qaz_LastRate", 100 - prePayRate - sendRate - rate1 - rate2);
        }

        /// <summary>
        /// 计算剩余比例
        /// </summary>
        /// <param name="fieldKey"></param>
        private void ComputeLastRate(string fieldKey)
        {
            if (fieldKey != "F_qaz_PrePayRate" && fieldKey != "F_qaz_SendRate" && fieldKey != "F_qaz_Rate1" && fieldKey != "F_qaz_Rate2") return;

            decimal prePayRate = Convert.ToDecimal(this.Model.GetValue("F_qaz_PrePayRate"));
            decimal sendRate = Convert.ToDecimal(this.Model.GetValue("F_qaz_SendRate"));
            decimal rate1 = Convert.ToDecimal(this.Model.GetValue("F_qaz_Rate1"));
            decimal rate2 = Convert.ToDecimal(this.Model.GetValue("F_qaz_Rate2"));

            this.Model.SetValue("F_qaz_LastRate", 100 - prePayRate - sendRate - rate1 - rate2);
        }

        /// <summary>
        /// 计算剩余比例
        /// </summary>
        /// <param name="fieldKey"></param>
        private void ComputeRate1(string fieldKey, int index)
        {
            var payWay = this.Model.GetValue("F_qaz_PayWay") as string;
            if (payWay == "4") return;
            if (fieldKey != "F_qaz_Rate" && index != 0) return;

            decimal rate1 = Convert.ToDecimal(this.Model.GetValue("F_qaz_Rate"));
            this.Model.SetValue("F_qaz_Rate1", rate1);
        }

        /// <summary>
        /// 计算剩余比例
        /// </summary>
        /// <param name="fieldKey"></param>
        private void ComputeRate2(string fieldKey, int index)
        {
            var payWay = this.Model.GetValue("F_qaz_PayWay") as string;
            if (payWay == "4") return;
            if (fieldKey != "F_qaz_Rate" && index != 1) return;

            decimal rate1 = Convert.ToDecimal(this.Model.GetValue("F_qaz_Rate", 1));
            this.Model.SetValue("F_qaz_Rate2", rate1);
        }

        /// <summary>
        /// 计算收款1天数
        /// </summary>
        /// <param name="fieldKey"></param>
        private void ComputeDay1(string fieldKey, int index)
        {
            if (fieldKey != "F_qaz_Day" && index != 0) return;

            int rate1 = Convert.ToInt32(this.Model.GetValue("F_qaz_Day"));
            this.Model.SetValue("F_qaz_AllDay1", rate1);
        }

        /// <summary>
        /// 计算收款2天数
        /// </summary>
        /// <param name="fieldKey"></param>
        private void ComputeDay2(string fieldKey, int index)
        {
            if (fieldKey != "F_qaz_Day" && index != 1) return;

            int rate1 = Convert.ToInt32(this.Model.GetValue("F_qaz_Day", 1));
            this.Model.SetValue("F_qaz_AllDay2", rate1);
        }


        /// <summary>
        /// 收款日期
        /// </summary>
        /// <param name="fieldKey"></param>
        private void ComputeDate(string fieldKey, int index)
        {
            if (fieldKey != "F_qaz_Date" && index != 0) return;

            var date = this.Model.GetValue("F_qaz_Date");
            this.Model.SetValue("F_qaz_RecDate", date);
        }

    }
}
