﻿using Kingdee.BOS;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core;
using Kingdee.BOS.Core.DynamicForm.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Core.Validation;
using Kingdee.BOS.Util;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LF.K3.SCM.AppServerPlugin.AuditChecks
{
    [Description("磊飞任务校验器")]
    [HotUpdate]
    public class BOMTaskCheckServer : AbstractValidator
    {
        public override void Validate(ExtendedDataEntity[] dataEntities, ValidateContext validateContext, Context ctx)
        {
            List<string> FMATERIALID = new List<string>();
            foreach (var dataEntity in dataEntities)
            {
                FMATERIALID.Add(dataEntity["PAREENTMATERIAL_Id"].ToString());
            }

            var wlID = "";
            for (int i = 0; i < FMATERIALID.Count; i++)
            {
                wlID += FMATERIALID[i] + ",";
            }
            string sql = $@"/*dialect*/select t1.FNAME,t2.FID BOMID from T_BD_MATERIAL_L t1 
                                        left join T_ENG_BOM t2 on t2.FMATERIALID=t1.FMATERIALID
                                        where t1.FMATERIALID in  ({wlID.Remove(wlID.LastIndexOf(","))}) ";
            DataTable dt = DBUtils.ExecuteDataSet(this.Context, sql).Tables[0];

            if (dt.Rows.Count > 0)
            {
                int i = 0;
                foreach (var et in dataEntities)
                {
                    var BOMID = dt.Rows[i]["BOMID"].ToString();
                    if (!BOMID.IsNullOrEmptyOrWhiteSpace())
                    {
                        validateContext.AddError(et, new ValidationErrorInfo(
                            "",//出错的字段key，可以空
                            et.DataEntity["id"].ToString(),
                            et.DataEntityIndex,
                            et.RowIndex,
                            "E1",
                            "父项物料名称为'" + dt.Rows[i]["FNAME"].ToString() + "'已创建BOM!",
                            "保存:",
                            ErrorLevel.FatalError
                            )
                            );
                    }
                    else
                    {
                        i++;
                        continue;
                    }
                    i++;
                }

            }
        }
    }
    [Description("磊飞任务校验")]
    [HotUpdate]
    public class BOMTaskCheck : AbstractOperationServicePlugIn
    {
        public override void OnAddValidators(AddValidatorsEventArgs e)
        {
            base.OnAddValidators(e);
            BOMTaskCheckServer auditcheck = new BOMTaskCheckServer();
            //是否需要校验，true需要
            auditcheck.AlwaysValidate = true;
            //校验单据体
            auditcheck.EntityKey = "FBillHead";
            //加载校验器
            e.Validators.Add(auditcheck);
        }
    }
}
