﻿using Kingdee.BOS;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core.DynamicForm.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Util;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;

namespace LF.K3.SCM.AppServerPlugin
{
    [Description("磊飞任务表保存插件")]
    [HotUpdate]
    public class BOMTaskEditionServer : AbstractOperationServicePlugIn
    {
        public override void AfterExecuteOperationTransaction(AfterExecuteOperationTransaction e)
        {
            List<string> FMATERIALID = new List<string>();
            foreach (var dataEntity in e.DataEntitys)
            {
                FMATERIALID .Add(dataEntity["PAREENTMATERIAL_Id"].ToString());
            }
          
            var wlID = "";
            for (int i = 0; i < FMATERIALID.Count; i++)
            {
                wlID += FMATERIALID[i]+",";
            }
            string sql = $@"/*dialect*/select t0.FID RWID,t1.FID BOMID,t1.FAPPROVEDATE from qaz_t_BOMTask001 T0 
                                        left join T_ENG_BOM T1 on t1.FMATERIALID=t0.FPAREENTMATERIAL
                                        where t0.FPAREENTMATERIAL in ({wlID.Remove(wlID.LastIndexOf(","))}) ";
            DataTable dt = DBUtils.ExecuteDataSet(this.Context, sql).Tables[0];
            List<SqlObject> sqllist = new List<SqlObject>();  
            if (dt.Rows.Count > 0)
            {
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    var RWID = dt.Rows[i]["RWID"].ToString();
                    var BOMID = dt.Rows[i]["BOMID"].ToString();
                    var FAPPROVEDATE = dt.Rows[i]["FAPPROVEDATE"].ToString();
                    if (!BOMID.IsNullOrEmptyOrWhiteSpace())
                    {
                        if (!FAPPROVEDATE.IsNullOrEmptyOrWhiteSpace())
                        {
                            string updatesql = $@"/*dialect*/update qaz_t_BOMTask001 set FBOM={BOMID},F_QAZ_DATE='{FAPPROVEDATE}' where FID={RWID}";
                            sqllist.Add(new SqlObject(updatesql, new List<SqlParam>()));
                        }
                        else
                        {
                            string updatesql = $@"/*dialect*/update qaz_t_BOMTask001 set FBOM={BOMID} where FID={RWID}";
                            sqllist.Add(new SqlObject(updatesql, new List<SqlParam>()));
                        }
                    }
                }
            }
            var a = DBUtils.ExecuteBatch(this.Context, sqllist);
            base.AfterExecuteOperationTransaction(e);

        }
    }
}
