﻿using Kingdee.BOS;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core.DynamicForm.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Util;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;

namespace LF.K3.SCM.AppServerPlugin
{
    [Description("BOM审核插件")]
    [HotUpdate]
    public class BOMTaskExamineServer : AbstractOperationServicePlugIn
    {
        public override void AfterExecuteOperationTransaction(AfterExecuteOperationTransaction e)
        {
            List<string> ApproveDate = new List<string>();
            List<string> FMATERIALID = new List<string>();
            foreach (var dataEntity in e.DataEntitys)
            {
                if (!dataEntity["ApproveDate"].ToString().IsNullOrEmptyOrWhiteSpace())
                {
                    ApproveDate.Add(dataEntity["ApproveDate"].ToString());
                    FMATERIALID.Add(dataEntity["MATERIALID_Id"].ToString());
                }
            }
            List<SqlObject> sqllist = new List<SqlObject>();
            for (int i = 0; i < ApproveDate.Count; i++)
            {
                string sql = $@"/*dialect*/update qaz_t_BOMTask001 set F_QAZ_DATE='{ApproveDate[i]}' where FID in (
                        select FID from qaz_t_BOMTask001 T0
                        WHERE FPAREENTMATERIAL = {FMATERIALID[i]}) ";
                sqllist.Add(new SqlObject(sql, new List<SqlParam>()));
            }
            var a = DBUtils.ExecuteBatch(this.Context, sqllist);
            base.AfterExecuteOperationTransaction(e);
        }
    }
}
