﻿using Kingdee.BOS;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core.Bill.PlugIn;
using Kingdee.BOS.Core.Bill.PlugIn.Args;
using Kingdee.BOS.Core.DynamicForm.Operation;
using Kingdee.BOS.Core.DynamicForm.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Util;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Dynamic;
using System.Linq;
using System.Text;

namespace LF.K3.SCM.AppServerPlugin
{
    [Description("物料清单表保存插件")]
    [HotUpdate]
    public class BomTaskSaveServer : AbstractOperationServicePlugIn
    {
        public override void AfterExecuteOperationTransaction(AfterExecuteOperationTransaction e)
        {
            List<string> FMATERIALID = new List<string>();
            List<string> ID = new List<string>();
            foreach (var dataEntity in e.DataEntitys)
            {
                FMATERIALID.Add(dataEntity["MATERIALID_Id"].ToString());
                ID.Add(dataEntity["Id"].ToString());
            }
            List<SqlObject> sqllist = new List<SqlObject>();
            for (int i = 0; i < FMATERIALID.Count; i++)
            {
                string sql = $@"/*dialect*/update qaz_t_BOMTask001 set FBOM={ID[i]} where FID in (
                        select FID from qaz_t_BOMTask001 T0
                        WHERE FPAREENTMATERIAL = {FMATERIALID[i]}) ";
                sqllist.Add(new SqlObject(sql, new List<SqlParam>()));
            }
            var a = DBUtils.ExecuteBatch(this.Context, sqllist);
            base.AfterExecuteOperationTransaction(e);

        }
    }
}
