﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace LF.K3.SCM.AppServerPlugin.OverdueReceivables
{

    /// <summary>
    /// 报表过滤
    /// </summary>
    class ReportFilter
    {
        /// <summary>
        /// 动态区间间隔时间
        /// </summary>
        public long DynamicStep { get; set; }
        /// <summary>
        /// 静态区间间隔时间
        /// </summary>
        public long StaticStep { get; set; }
        /// <summary>
        /// 查询报表日
        /// </summary>
        public DateTime? StaticDate { get; set; }
        /// <summary>
        /// 组织
        /// </summary>
        public long OrgId { get; set; }
        /// <summary>
        /// 区域
        /// </summary>
        public string Area { get; set; }
        /// <summary>
        /// 销售员
        /// </summary>
        public long Saler { get; set; }
        /// <summary>
        /// 客户
        /// </summary>
        public long Customer { get; set; }
        /// <summary>
        /// 工程
        /// </summary>
        public string Project { get; set; }
        /// <summary>
        /// 币种
        /// </summary>
        public long Currency { get; set; }
        /// <summary>
        /// 合同号
        /// </summary>
        public string Contract { get; set; }
        /// <summary>
        /// 合同签署日期开始
        /// </summary>
        public DateTime? SignBeginDate { get; set; }
        /// <summary>
        /// 合同签署日期结束
        /// </summary>
        public DateTime? SignEndDate { get; set; }
        /// <summary>
        /// 合同金额开始
        /// </summary>
        public decimal ContractBeginAmount { get; set; }
        /// <summary>
        /// 合同金额结束
        /// </summary>
        public decimal ContractEndAmount { get; set; }
        /// <summary>
        /// 应收金额开始
        /// </summary>
        public decimal ReceiveableBeginAmount { get; set; }

        /// <summary>
        /// 应收金额结束
        /// </summary>
        public decimal ReceiveableEndAmount { get; set; }

        /// <summary>
        /// 逾期金额大于
        /// </summary>
        public decimal OverdueBeginAmount { get; set; }

        /// <summary>
        /// 逾期金额小于
        /// </summary>
        public decimal OverdueEndAmount { get; set; }

        /// <summary>
        /// 客户类别
        /// </summary>
        public string CustTypeId { get; set; }
        /// <summary>
        /// 是否回款
        /// </summary>
        public bool IsReturn { get; set; }
    }
}
