﻿using Kingdee.BOS;
using Kingdee.BOS.App;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Contracts;
using Kingdee.BOS.Contracts.Report;
using Kingdee.BOS.Core.Enums;
using Kingdee.BOS.Core.Report;
using Kingdee.BOS.Log;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.Util;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using Kingdee.BOS.Core.List;
using Kingdee.BOS.Core.List.PlugIn;
using Kingdee.BOS.Core.DynamicForm;



namespace LF.K3.SCM.AppServerPlugin.OverdueReceivables
{
	[HotUpdate]
	[Description("逾期账龄表报表服务器插件")]
	public class ReportServerPlugin : SysReportBaseService
	{
		private string tmpTable;
		private ReportFilter reportFilter;
		private int maxReceiveTime = 0;
		public override void BuilderReportSqlAndTempTable(IRptParams filter, string tableName)
		{
			GetFilter(filter.FilterParameter.CustomFilter);
			GetDynamicReceive();
			//base.ReportProperty.TempTableType = BOSEnums.Enu_TempTableType.View;
			this.GenSql(filter, tableName);
			base.BuilderReportSqlAndTempTable(filter, tableName);
		}
        public override void Initialize()
        {
			//精度控制
			List<DecimalControlField> list = new List<DecimalControlField>();
            //合同金额
            list.Add(new DecimalControlField
            {
                ByDecimalControlFieldName = "FContractAmount",
                DecimalControlFieldName = "FPrecision"
            });
            //发货金额
            list.Add(new DecimalControlField
            {
                ByDecimalControlFieldName = "FSendAmount",
                DecimalControlFieldName = "FPrecision"
            });
            //退货金额
            list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FReturnAmount",
				DecimalControlFieldName = "FPrecision"
			});
			//发货签收金额
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FAcceptAmount",
				DecimalControlFieldName = "FPrecision"
			});
			//回款金额
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FBackAmount",
				DecimalControlFieldName = "FPrecision"
			});
			//应收金额
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FAcceptAbleAmount",
				DecimalControlFieldName = "FPrecision"
			});
			//预付款&到期金额
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FPrePayExpireAmout",
				DecimalControlFieldName = "FPrecision"
			});
			//预付款&回款金额
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FPrePayBackAmount",
				DecimalControlFieldName = "FPrecision"
			});
			//&预付款&逾期金额
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FPrepayOverdueAmount",
				DecimalControlFieldName = "FPrecision"
			});
			//发货款&到期金额
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FPayInSendPayExpireAmout",
				DecimalControlFieldName = "FPrecision"
			});
			//发货款&回款金额
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FPayInSendPayBackAmount",
				DecimalControlFieldName = "FPrecision"
			});
			//发货款&逾期金额
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FPayInSendpayOverdueAmount",
				DecimalControlFieldName = "FPrecision"
			});
			//发货款(现款现货订单专用）&到期金额
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FPayExpireAmoutNoDate",
				DecimalControlFieldName = "FPrecision"
			});
			//发货款(现款现货订单专用）&回款金额
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FPayBackAmountNoDate",
				DecimalControlFieldName = "FPrecision"
			});
			//发货款(现款现货订单专用）&逾期金额
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FpayOverdueAmountNoDate",
				DecimalControlFieldName = "FPrecision"
			});
			//签收款1&到期金额
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FPayExpireAmout1",
				DecimalControlFieldName = "FPrecision"
			});
			//签收款1&回款金额
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FPayBackAmount1",
				DecimalControlFieldName = "FPrecision"
			});
			//签收款1&逾期金额
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FpayOverdueAmount1",
				DecimalControlFieldName = "FPrecision"
			});
			//签收款2&到期金额
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FPayExpireAmout2",
				DecimalControlFieldName = "FPrecision"
			});
			//签收款2&回款金额
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FPayBackAmount2",
				DecimalControlFieldName = "FPrecision"
			});
			//签收款2&逾期金额
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FpayOverdueAmount2",
				DecimalControlFieldName = "FPrecision"
			});
			//指定日期款&到期金额
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FPayExpireAmoutDeadLine",
				DecimalControlFieldName = "FPrecision"
			});
			//指定日期款&回款金额
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FPayBackAmountDeadLine",
				DecimalControlFieldName = "FPrecision"
			});
			//指定日期款&逾期金额
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FpayOverdueAmountDeadLine",
				DecimalControlFieldName = "FPrecision"
			});
			//商业条款参数及计算&未匹配货款
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FPayExpireAmoutNoMatch",
				DecimalControlFieldName = "FPrecision"
			});
			//动态区间
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "Flower1Day",
				DecimalControlFieldName = "FPrecision"
			});
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FIntervalDay1",
				DecimalControlFieldName = "FPrecision"
			});
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FIntervalDay2",
				DecimalControlFieldName = "FPrecision"
			});
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FIntervalDay3",
				DecimalControlFieldName = "FPrecision"
			});
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FIntervalDay4",
				DecimalControlFieldName = "FPrecision"
			});
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FIntervalDay5",
				DecimalControlFieldName = "FPrecision"
			});
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FIntervalDay6",
				DecimalControlFieldName = "FPrecision"
			});
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FIntervalDay7",
				DecimalControlFieldName = "FPrecision"
			});
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FIntervalDay8",
				DecimalControlFieldName = "FPrecision"
			});
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FHigherDay",
				DecimalControlFieldName = "FPrecision"
			});
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FSumDay",
				DecimalControlFieldName = "FPrecision"
			});
			//静态区间
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FIntervalStaticDay1",
				DecimalControlFieldName = "FPrecision"
			});
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FIntervalStaticDay2",
				DecimalControlFieldName = "FPrecision"
			});
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FIntervalStaticDay3",
				DecimalControlFieldName = "FPrecision"
			});
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FIntervalStaticDay4",
				DecimalControlFieldName = "FPrecision"
			});
			list.Add(new DecimalControlField
			{
				ByDecimalControlFieldName = "FIntervalStaticDay5",
				DecimalControlFieldName = "FPrecision"
			});
			this.ReportProperty.DecimalControlFieldList = list;
			base.Initialize();
        }
        /// <summary>
        /// 获取过滤条件
        /// </summary>
        /// <param name="fiter"></param>
        private void GetFilter(DynamicObject fiter)
		{
			reportFilter = new ReportFilter()
			{
				DynamicStep = Convert.ToInt64(fiter["FDynamicTime"]),
				StaticStep = Convert.ToInt64(fiter["FStaticTime"]),
				Area = fiter["FArea"] as string,
				Contract = fiter["FContract"] as string,
				ContractBeginAmount = Convert.ToDecimal(fiter["FContractBeginAmount"]),
				ContractEndAmount = Convert.ToDecimal(fiter["FContractEndAmount"]),
				Currency = Convert.ToInt64(fiter["FCurrency_Id"]),
				Customer = Convert.ToInt64(fiter["FCustomer_Id"]),
				SignBeginDate = fiter["FSignBeginDate"] as DateTime?,
				SignEndDate = fiter["FSignEndDate"] as DateTime?,
				OrgId = Convert.ToInt64(fiter["FOrgId_Id"]),
				Project = fiter["FProject"] as string,
				ReceiveableBeginAmount = Convert.ToDecimal(fiter["FReceiveableBeginAmount"]),
				ReceiveableEndAmount = Convert.ToDecimal(fiter["FReceiveableEndAmount"]),
				Saler = Convert.ToInt64(fiter["FSaler_Id"]),
				StaticDate = fiter["FStaticDate"] as DateTime?,
				CustTypeId = fiter["FCustTypeId_Id"] as string,
				OverdueBeginAmount = Convert.ToDecimal(fiter["FOverdueBeginAmount"]),
				OverdueEndAmount = Convert.ToDecimal(fiter["FOverdueEndAmount"]),
				IsReturn = Convert.ToBoolean(fiter["FIsReturnChe"])
			};
		}

		public override ReportHeader GetReportHeaders(IRptParams filter)
		{
			ReportHeader reportHeader = new ReportHeader();
			reportHeader.AddChild("FArea", new LocaleValue("基础数据&区域", base.Context.UserLocale.LCID));
			reportHeader.AddChild("FSaler", new LocaleValue("基础数据&销售员", base.Context.UserLocale.LCID));
			reportHeader.AddChild("FCustomer", new LocaleValue("基础数据&客户名称", base.Context.UserLocale.LCID));
			reportHeader.AddChild("FProject", new LocaleValue("基础数据&项目名称", base.Context.UserLocale.LCID));
			reportHeader.AddChild("FContract", new LocaleValue("基础数据&合同号", base.Context.UserLocale.LCID));
			reportHeader.AddChild("FReceive", new LocaleValue("基础数据&收款条件", base.Context.UserLocale.LCID));
			reportHeader.AddChild("FContractDate", new LocaleValue("基础数据&合同签署日期", base.Context.UserLocale.LCID));
			var a= reportHeader.AddChild("FContractAmount", new LocaleValue("基础数据&合同金额", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FSendAmount", new LocaleValue("基础数据&发货金额", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FReturnAmount", new LocaleValue("基础数据&退货金额", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FAcceptAmount", new LocaleValue("基础数据&发货签收金额", base.Context.UserLocale.LCID),SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FBackAmount", new LocaleValue("基础数据&回款金额", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FAcceptAbleAmount", new LocaleValue("基础数据&应收金额", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FSettleOrg", new LocaleValue("基础数据&结算组织", base.Context.UserLocale.LCID));
			reportHeader.AddChild("FFirstDay", new LocaleValue("基础数据&首次发货日", base.Context.UserLocale.LCID));
			reportHeader.AddChild("FEndDay", new LocaleValue("基础数据&末次发货日", base.Context.UserLocale.LCID));
			reportHeader.AddChild("FCurrency", new LocaleValue("基础数据&币种", base.Context.UserLocale.LCID));

			reportHeader.AddChild("FPrePayRate", new LocaleValue("商业条款参数及计算&预付款&货款比例", base.Context.UserLocale.LCID));
			reportHeader.AddChild("FPrePayDate", new LocaleValue("商业条款参数及计算&预付款&账期天数", base.Context.UserLocale.LCID), SqlStorageType.SqlFloat);
			reportHeader.AddChild("FPrePayExpireDate", new LocaleValue("商业条款参数及计算&预付款&到期日", base.Context.UserLocale.LCID));
			reportHeader.AddChild("FPrePayExpireAmout", new LocaleValue("商业条款参数及计算&预付款&到期金额", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FPrePayBackAmount", new LocaleValue("商业条款参数及计算&预付款&回款金额", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FPrepayOverdueAmount", new LocaleValue("商业条款参数及计算&预付款&逾期金额", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FPrepayOverdueDay", new LocaleValue("商业条款参数及计算&预付款&逾期天数", base.Context.UserLocale.LCID), SqlStorageType.SqlFloat);

			reportHeader.AddChild("FPayInSendPayRate", new LocaleValue("商业条款参数及计算&发货款&货款比例", base.Context.UserLocale.LCID));
			reportHeader.AddChild("FPayInSendDate", new LocaleValue("商业条款参数及计算&发货款&账期天数", base.Context.UserLocale.LCID), SqlStorageType.SqlFloat);
			reportHeader.AddChild("FPayInSendExpireDate", new LocaleValue("商业条款参数及计算&发货款&到期日", base.Context.UserLocale.LCID));
			reportHeader.AddChild("FPayInSendPayExpireAmout", new LocaleValue("商业条款参数及计算&发货款&到期金额", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FPayInSendPayBackAmount", new LocaleValue("商业条款参数及计算&发货款&回款金额", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FPayInSendpayOverdueAmount", new LocaleValue("商业条款参数及计算&发货款&逾期金额", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FPayInSendpayOverdueDay", new LocaleValue("商业条款参数及计算&发货款&逾期天数", base.Context.UserLocale.LCID), SqlStorageType.SqlFloat);

			reportHeader.AddChild("FPayPayNoDateLineRate", new LocaleValue("商业条款参数及计算&发货款(现款现货订单专用）&货款比例", base.Context.UserLocale.LCID));
			reportHeader.AddChild("FPayDateNoDate", new LocaleValue("商业条款参数及计算&发货款(现款现货订单专用）&账期天数", base.Context.UserLocale.LCID), SqlStorageType.SqlFloat);
			reportHeader.AddChild("FExpireDateNoDate", new LocaleValue("商业条款参数及计算&发货款(现款现货订单专用）&到期日", base.Context.UserLocale.LCID));
			reportHeader.AddChild("FPayExpireAmoutNoDate", new LocaleValue("商业条款参数及计算&发货款(现款现货订单专用）&到期金额", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FPayBackAmountNoDate", new LocaleValue("商业条款参数及计算&发货款(现款现货订单专用）&回款金额", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FpayOverdueAmountNoDate", new LocaleValue("商业条款参数及计算&发货款(现款现货订单专用）&逾期金额", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FpayOverdueDayNoDate", new LocaleValue("商业条款参数及计算&发货款(现款现货订单专用）&逾期天数", base.Context.UserLocale.LCID), SqlStorageType.SqlFloat);

			reportHeader.AddChild("FPayPay1Rate", new LocaleValue("商业条款参数及计算&签收款1&货款比例", base.Context.UserLocale.LCID));
			reportHeader.AddChild("FPayDate1", new LocaleValue("商业条款参数及计算&签收款1&账期天数", base.Context.UserLocale.LCID), SqlStorageType.SqlFloat);
			reportHeader.AddChild("FExpireDate1", new LocaleValue("商业条款参数及计算&签收款1&到期日", base.Context.UserLocale.LCID));
			reportHeader.AddChild("FPayExpireAmout1", new LocaleValue("商业条款参数及计算&签收款1&到期金额", base.Context.UserLocale.LCID),SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FPayBackAmount1", new LocaleValue("商业条款参数及计算&签收款1&回款金额", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FpayOverdueAmount1", new LocaleValue("商业条款参数及计算&签收款1&逾期金额", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FpayOverdueDay1", new LocaleValue("商业条款参数及计算&签收款1&逾期天数", base.Context.UserLocale.LCID), SqlStorageType.SqlFloat);

			reportHeader.AddChild("FPayPay2Rate", new LocaleValue("商业条款参数及计算&签收款2&货款比例", base.Context.UserLocale.LCID));
			reportHeader.AddChild("FPayDate2", new LocaleValue("商业条款参数及计算&签收款2&账期天数", base.Context.UserLocale.LCID), SqlStorageType.SqlFloat);
			reportHeader.AddChild("FExpireDate2", new LocaleValue("商业条款参数及计算&签收款2&到期日", base.Context.UserLocale.LCID));
			reportHeader.AddChild("FPayExpireAmout2", new LocaleValue("商业条款参数及计算&签收款2&到期金额", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FPayBackAmount2", new LocaleValue("商业条款参数及计算&签收款2&回款金额", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FpayOverdueAmount2", new LocaleValue("商业条款参数及计算&签收款2&逾期金额", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FpayOverdueDay2", new LocaleValue("商业条款参数及计算&签收款2&逾期天数", base.Context.UserLocale.LCID),SqlStorageType.SqlFloat);

			reportHeader.AddChild("FPayPayDeadLineRate", new LocaleValue("商业条款参数及计算&指定日期款&货款比例", base.Context.UserLocale.LCID));
			reportHeader.AddChild("FPayDateDeadLine", new LocaleValue("商业条款参数及计算&指定日期款&账期天数", base.Context.UserLocale.LCID), SqlStorageType.SqlFloat);
			reportHeader.AddChild("FExpireDateDeadLine", new LocaleValue("商业条款参数及计算&指定日期款&到期日", base.Context.UserLocale.LCID));
			reportHeader.AddChild("FPayExpireAmoutDeadLine", new LocaleValue("商业条款参数及计算&指定日期款&到期金额", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FPayBackAmountDeadLine", new LocaleValue("商业条款参数及计算&指定日期款&回款金额", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FpayOverdueAmountDeadLine", new LocaleValue("商业条款参数及计算&指定日期款&逾期金额", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FpayOverdueDayDeadLine", new LocaleValue("商业条款参数及计算&指定日期款&逾期天数", base.Context.UserLocale.LCID), SqlStorageType.SqlFloat);

			reportHeader.AddChild("FPayExpireAmoutNoMatch", new LocaleValue("商业条款参数及计算&未匹配货款", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);

			reportHeader.AddChild("Flower1Day", new LocaleValue("动态区间&<1 days", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FIntervalDay1", new LocaleValue($"动态区间&1-{reportFilter.DynamicStep} days", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FIntervalDay2", new LocaleValue($"动态区间&{reportFilter.DynamicStep + 1}-{reportFilter.DynamicStep * 2} days", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FIntervalDay3", new LocaleValue($"动态区间&{reportFilter.DynamicStep * 2 + 1}-{reportFilter.DynamicStep * 3} days", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FIntervalDay4", new LocaleValue($"动态区间&{reportFilter.DynamicStep * 3 + 1}-{reportFilter.DynamicStep * 4} days", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FIntervalDay5", new LocaleValue($"动态区间&{reportFilter.DynamicStep * 4 + 1}-{reportFilter.DynamicStep * 5} days", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FIntervalDay6", new LocaleValue($"动态区间&{reportFilter.DynamicStep * 5 + 1}-{reportFilter.DynamicStep * 6} days", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FIntervalDay7", new LocaleValue($"动态区间&{reportFilter.DynamicStep * 6 + 1}-{reportFilter.DynamicStep * 7} days", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FIntervalDay8", new LocaleValue($"动态区间&{reportFilter.DynamicStep * 7 + 1}-{reportFilter.DynamicStep * 8} days", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FHigherDay", new LocaleValue($"动态区间&> {reportFilter.DynamicStep * 8 + 1} days", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FSumDay", new LocaleValue($"动态区间&逾期金额合计", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);

			reportHeader.AddChild("FLastPayDay", new LocaleValue("静态区间计算&末次回款日", base.Context.UserLocale.LCID));
			reportHeader.AddChild("FMaxEndDay", new LocaleValue("静态区间计算&最大到期日", base.Context.UserLocale.LCID));
			reportHeader.AddChild("FOverdueDay", new LocaleValue("静态区间计算&逾期天数", base.Context.UserLocale.LCID), SqlStorageType.SqlFloat);

			reportHeader.AddChild("FIntervalStaticDay1", new LocaleValue($"静态区间&< {reportFilter.StaticStep} days", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FIntervalStaticDay2", new LocaleValue($"静态区间&{reportFilter.StaticStep + 1}-{reportFilter.StaticStep * 2} days", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FIntervalStaticDay3", new LocaleValue($"静态区间&{reportFilter.StaticStep * 2 + 1}-{reportFilter.StaticStep * 3} days", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FIntervalStaticDay4", new LocaleValue($"静态区间&{reportFilter.StaticStep * 3 + 1}-{reportFilter.StaticStep * 4} days", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
			reportHeader.AddChild("FIntervalStaticDay5", new LocaleValue($"静态区间&> {reportFilter.StaticStep * 4 + 1} days", base.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);

			for (int index = 0; index < maxReceiveTime; index++)
			{
				reportHeader.AddChild($"FReceiveDate{ (index + 1)}", new LocaleValue($"回款记录&回款时间{ (index + 1)}", base.Context.UserLocale.LCID));
				reportHeader.AddChild($"FReceiveAmount{ (index + 1)}", new LocaleValue($"回款记录&回款金额{ (index + 1)}", base.Context.UserLocale.LCID), SqlStorageType.SqlFloat);
				reportHeader.AddChild($"FReceiveSettleType{ (index + 1)}", new LocaleValue($"回款记录&结算方式{ (index + 1)}", base.Context.UserLocale.LCID));
			}

			return reportHeader;
		}

		private void GetDynamicReceive()
		{

			IDBService dBService = ServiceHelper.GetService<IDBService>();
			tmpTable = dBService.CreateTemporaryTableName(this.Context);
			Dictionary<string, List<dynamic>> receiveDic = new Dictionary<string, List<dynamic>>();

			string sql = @"/*dialect*/select T0.FDATE, convert(nvarchar,cast(CONVERT(decimal(18,2),T0.FRECAMOUNTFOR_E) as money),1) FRECAMOUNTFOR_E, T1_L.FNAME FSETTLETYPE, T2.FNUMBER FContract  from (
	select T0.FDate FDate, T0Entry.F_QAZ_ASSISTANT F_QAZ_ASSISTANT, T0Entry.FSETTLETYPEID FSETTLETYPEID, sum(T0Entry.FRECAMOUNTFOR_E) FRECAMOUNTFOR_E from T_AR_RECEIVEBILL T0 inner join T_AR_RECEIVEBILLENTRY T0Entry on T0.FID = T0Entry.FID group by T0.FDate, T0Entry.F_QAZ_ASSISTANT, T0Entry.FSETTLETYPEID
	) T0 inner join T_BAS_ASSISTANTDATAENTRY T2 on T0.F_QAZ_ASSISTANT = T2.FENTRYID and T2.fid = '5d14472db259d7' and FENTRYID != '5dbbc611207bfd'
	left join T_BD_SETTLETYPE_L T1_L on T0.FSETTLETYPEID = T1_L.FID and FLOCALEID = 2052";
			using (IDataReader reader = DBUtils.ExecuteReader(this.Context, sql))
			{
				while (reader.Read())
				{
					string contract = reader["FContract"] as string;
					string date = reader["FDATE"] == null ? "" : Convert.ToDateTime(reader["FDATE"]).ToString("yyyy-MM-dd");
					string amount = reader["FRECAMOUNTFOR_E"].ToString();
					string settleType = reader["FSETTLETYPE"] as string;
					if (string.IsNullOrWhiteSpace(contract)) continue;

					List<dynamic> receiveList;
					if (!receiveDic.TryGetValue(contract, out receiveList))
					{
						receiveList = new List<dynamic>();
						receiveDic.Add(contract, receiveList);
					}
					receiveList.Add(new { date = date, amount = amount, settleType = settleType });
					if (maxReceiveTime < receiveList.Count)
					{
						maxReceiveTime = receiveList.Count;
					}
				}
			}

			List<string> columns = new List<string>();

			for (int index = 0; index < maxReceiveTime; index++)
			{
				columns.Add(string.Format(", FReceiveDate{0} NVARCHAR(255)", (index + 1)));
				columns.Add(string.Format(", FReceiveAmount{0} NVARCHAR(255)", (index + 1)));
				columns.Add(string.Format(", FReceiveSettleType{0} NVARCHAR(255)", (index + 1)));
			}

			string tmpTableCreateSQL = "create table {0}(FReceiveContract NVARCHAR(255) primary key {1} )";
			tmpTableCreateSQL = string.Format(tmpTableCreateSQL, tmpTable, string.Join("", columns));
			DBUtils.Execute(this.Context, tmpTableCreateSQL);

			DataTable dt = DBUtils.ExecuteDataSet(this.Context, $"select * from {tmpTable}").Tables[0];
			dt.TableName = tmpTable;
			foreach (string key in receiveDic.Keys)
			{
				var newRow = dt.NewRow();
				newRow["FReceiveContract"] = key;
				dt.Rows.Add(newRow);
				List<dynamic> reveiveList = receiveDic[key];
				foreach (var receive in reveiveList)
				{
					int index = reveiveList.IndexOf(receive);
					newRow["FReceiveDate" + (index + 1)] = receive.date;
					newRow["FReceiveAmount" + (index + 1)] = receive.amount;
					newRow["FReceiveSettleType" + (index + 1)] = receive.settleType;
				}

			}
			if (dt.Rows.Count > 0)
			{
				DBUtils.BulkInserts(this.Context, dt);
			}
		}

		private void GenSql(IRptParams filter, string tableName)
		{
			string filterStr = string.Empty;
			if (reportFilter.OrgId > 0)
			{
				filterStr += " and isnull(isnull(isnull(F.zz, I.jszz), T0.FPAYORGID), H.jszz) = " + reportFilter.OrgId;
			}

			if (reportFilter.Saler > 0)
			{
				filterStr += " and A.F_QAZ_BASE1 = " + reportFilter.Saler;
			}

			if (reportFilter.Customer > 0)
			{
				filterStr += " and A.F_QAZ_BASE2 = " + reportFilter.Customer;
			}

			if (reportFilter.SignBeginDate != null)
			{
				filterStr += $" and A.F_QAZ_DATE >= '{reportFilter.SignBeginDate}'";
			}

			if (reportFilter.SignEndDate != null)
			{
				filterStr += $" and A.F_QAZ_DATE <= '{reportFilter.SignEndDate}'";
			}

			if (reportFilter.ContractBeginAmount > 0)
			{
				filterStr += " and A.F_QAZ_AMOUNT >= " + reportFilter.ContractBeginAmount;
			}

			if (reportFilter.ContractEndAmount > 0)
			{
				filterStr += " and A.F_QAZ_AMOUNT <= " + reportFilter.ContractEndAmount;
			}

			if (reportFilter.ReceiveableBeginAmount > 0)
			{
				filterStr += " and isnull(G.zysdje,0)+isnull(H.zqtysje,0)-(isnull(T0.contractionAmount,0) - isnull(I.whx,0)) >= " + reportFilter.ReceiveableBeginAmount;
			}

			if (reportFilter.ReceiveableEndAmount > 0)
			{
				filterStr += " and isnull(G.zysdje,0)+isnull(H.zqtysje,0)-(isnull(T0.contractionAmount,0) - isnull(I.whx,0)) <= " + reportFilter.ReceiveableEndAmount;
			}

			if (reportFilter.Currency > 0)
			{
				filterStr += " and isnull(isnull(isnull(F.FSETTLECURRID, I.FSETTLECUR), T0.FSETTLECUR), H.FCURRENCYID) = " + reportFilter.Currency;
			}
			
			string outFilterStr = string.Empty;
			outFilterStr += " FIntervalDay1 + FIntervalDay2 + FIntervalDay3 + FIntervalDay4 + FIntervalDay5 + FIntervalDay6 + FIntervalDay7 + FIntervalDay8 + FHigherDay >= " + reportFilter.OverdueBeginAmount;
			if (reportFilter.OverdueEndAmount > 0)
			{
				outFilterStr += " and FIntervalDay1 + FIntervalDay2 + FIntervalDay3 + FIntervalDay4 + FIntervalDay5 + FIntervalDay6 + FIntervalDay7 + FIntervalDay8 + FHigherDay <= " + reportFilter.OverdueEndAmount;
			}
			if (reportFilter.IsReturn == true)
			{
				outFilterStr += " and (FContractAmount!=FSendAmount or FContractAmount!=FAcceptAmount or FContractAmount!=FBackAmount)";
			}


			string strSQL = @"/*dialect*/
								select ROW_NUMBER() OVER(order by A.FContract) as FIDENTITYID,A.FEntryID, B.*
										,FArea 
										,FSaler 
										,FCustomer 
										,FProject 
										,FContract 
										,FReceive 
										,FSettleOrg 
										,FCurrency 
										,FPrePayDate 
										,FPrepayOverdueDay 
										,FPayInSendDate
										,FPayInSendpayOverdueDay 
										,FPayDateNoDate 
										,FpayOverdueDayNoDate 
										,FPayDate1 
										,FpayOverdueDay1 
										,FPayDate2 
										,FpayOverdueDay2 
										,FPayDateDeadLine 
										,FpayOverdueDayDeadLine 
										,FOverdueDay 
										,convert(nvarchar,cast(CONVERT(decimal(18,2),Flower1Day ) as money),1) Flower1Day 
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FIntervalDay1 ) as money),1) FIntervalDay1 
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FIntervalDay2 ) as money),1) FIntervalDay2 
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FIntervalDay3 ) as money),1) FIntervalDay3 
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FIntervalDay4 ) as money),1) FIntervalDay4 
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FIntervalDay5 ) as money),1) FIntervalDay5 
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FIntervalDay6 ) as money),1) FIntervalDay6 
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FIntervalDay7 ) as money),1) FIntervalDay7 
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FIntervalDay8 ) as money),1) FIntervalDay8 
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FHigherDay ) as money),1) FHigherDay 
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FIntervalStaticDay1 ) as money),1) FIntervalStaticDay1 
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FIntervalStaticDay2 ) as money),1) FIntervalStaticDay2 
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FIntervalStaticDay3 ) as money),1) FIntervalStaticDay3 
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FIntervalStaticDay4 ) as money),1) FIntervalStaticDay4 
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FIntervalStaticDay5 ) as money),1) FIntervalStaticDay5
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FIntervalDay1 + FIntervalDay2 + FIntervalDay3 + FIntervalDay4 + FIntervalDay5 + FIntervalDay6 + FIntervalDay7 + FIntervalDay8 + FHigherDay) as money),1) FSumDay
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FContractAmount) as money),1) FContractAmount
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FSendAmount) as money),1) FSendAmount
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FReturnAmount) as money),1) FReturnAmount
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FAcceptAmount) as money),1) FAcceptAmount
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FBackAmount) as money),1) FBackAmount
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FAcceptAbleAmount) as money),1) FAcceptAbleAmount
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FPrePayExpireAmout) as money),1) FPrePayExpireAmout
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FPrePayBackAmount) as money),1) FPrePayBackAmount
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FPrepayOverdueAmount) as money),1) FPrepayOverdueAmount
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FPayInSendPayExpireAmout) as money),1) FPayInSendPayExpireAmout
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FPayInSendPayBackAmount) as money),1) FPayInSendPayBackAmount
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FPayInSendpayOverdueAmount) as money),1) FPayInSendpayOverdueAmount
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FPayExpireAmoutNoDate) as money),1) FPayExpireAmoutNoDate
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FPayBackAmountNoDate) as money),1) FPayBackAmountNoDate
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FpayOverdueAmountNoDate) as money),1) FpayOverdueAmountNoDate
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FPayExpireAmout1) as money),1) FPayExpireAmout1
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FPayBackAmount1) as money),1) FPayBackAmount1
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FpayOverdueAmount1) as money),1) FpayOverdueAmount1
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FPayExpireAmout2) as money),1) FPayExpireAmout2
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FPayBackAmount2) as money),1) FPayBackAmount2
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FpayOverdueAmount2) as money),1) FpayOverdueAmount2
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FPayExpireAmoutDeadLine) as money),1) FPayExpireAmoutDeadLine
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FPayBackAmountDeadLine) as money),1) FPayBackAmountDeadLine
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FpayOverdueAmountDeadLine) as money),1) FpayOverdueAmountDeadLine
										,convert(nvarchar,cast(CONVERT(decimal(18,2),FPayExpireAmoutNoMatch) as money),1) FPayExpireAmoutNoMatch
										,CONVERT(varchar, FContractDate, 23) FContractDate
										,CONVERT(varchar, FFirstDay, 23) FFirstDay
										,CONVERT(varchar, FEndDay, 23) FEndDay
										,CONVERT(varchar, FPrePayExpireDate, 23) FPrePayExpireDate
										,CONVERT(varchar, FPayInSendExpireDate, 23) FPayInSendExpireDate
										,CONVERT(varchar, FExpireDateNoDate, 23) FExpireDateNoDate
										,CONVERT(varchar, FExpireDate1, 23) FExpireDate1
										,CONVERT(varchar, FExpireDate2, 23) FExpireDate2
										,CONVERT(varchar, FExpireDateDeadLine, 23) FExpireDateDeadLine
										,CONVERT(varchar, FMaxEndDay, 23) FMaxEndDay
										,CONVERT(varchar, FLastPayDay, 23) FLastPayDay
										,CONVERT(varchar, CONVERT(decimal(18,2),FPrePayRate )) + '%' FPrePayRate
										,CONVERT(varchar, CONVERT(decimal(18,2),FPayInSendPayRate )) + '%' FPayInSendPayRate
										,CONVERT(varchar, CONVERT(decimal(18,2),FPayPayNoDateLineRate )) + '%' FPayPayNoDateLineRate
										,CONVERT(varchar, CONVERT(decimal(18,2),FPayPay1Rate )) + '%' FPayPay1Rate
										,CONVERT(varchar, CONVERT(decimal(18,2),FPayPay2Rate )) + '%' FPayPay2Rate
										,CONVERT(varchar, CONVERT(decimal(18,2),FPayPayDeadLineRate )) + '%' FPayPayDeadLineRate
                                        ,2 as FPrecision
									into {0} from (
									select A.*
										, (case when FOverdueDay <= {2} then F_QAZ_AMOUNT end)  FIntervalStaticDay1
										, (case when FOverdueDay > {2} and FOverdueDay <= 2 * {2} then F_QAZ_AMOUNT end)  FIntervalStaticDay2
										, (case when FOverdueDay > 2 * {2} and FOverdueDay <= 3 * {2} then F_QAZ_AMOUNT end)  FIntervalStaticDay3
										, (case when FOverdueDay > 3 * {2} and FOverdueDay <= 4 * {2} then F_QAZ_AMOUNT end)  FIntervalStaticDay4
										, (case when FOverdueDay > 4 * {2} then F_QAZ_AMOUNT end)  FIntervalStaticDay5
										, (CASE WHEN FPrepayOverdueDay <= 0 THEN FPrepayOverdueAmount else 0 end) + (CASE WHEN FPayInSendpayOverdueDay <= 0 THEN FPayInSendpayOverdueAmount else 0 end) + (CASE WHEN FpayOverdueDay1 <= 0 THEN FpayOverdueAmount1 else 0 end) + (CASE  WHEN FpayOverdueDay2 <= 0 THEN  FpayOverdueAmount2 else 0 end) + (CASE  WHEN FpayOverdueDayDeadLine <= 0 THEN FpayOverdueAmountDeadLine else 0 end) + (CASE  WHEN FpayOverdueDayNoDate <= 0 THEN FpayOverdueAmountNoDate else 0 end)  Flower1Day
										, (CASE WHEN {1} >=     FPrepayOverdueDay and FPrepayOverdueDay > 0       THEN FPrepayOverdueAmount  else 0 end) + (CASE  WHEN {1} >      FPayInSendpayOverdueDay and FPayInSendpayOverdueDay >  0      THEN FPayInSendpayOverdueAmount else 0 end) + (CASE  WHEN {1} >=     FpayOverdueDay1 and FpayOverdueDay1 >  0      THEN FpayOverdueAmount1 else 0 end) + (CASE  WHEN {1} >=     FpayOverdueDay2 and FpayOverdueDay2 >  0      THEN  FpayOverdueAmount2 else 0 end) + (CASE  WHEN {1} >=     FpayOverdueDayDeadLine and FpayOverdueDayDeadLine >  0      THEN FpayOverdueAmountDeadLine else 0 end) + (CASE  WHEN {1} >=     FpayOverdueDayNoDate and FpayOverdueDayNoDate >  0      THEN FpayOverdueAmountNoDate else 0 end)  FIntervalDay1
										, (CASE WHEN 2 * {1} >= FPrepayOverdueDay and FPrepayOverdueDay > {1}     THEN FPrepayOverdueAmount else 0 end) + (CASE  WHEN 2 * {1} >= FPayInSendpayOverdueDay and FPayInSendpayOverdueDay > {1}     THEN FPayInSendpayOverdueAmount else 0 end) + (CASE  WHEN 2 * {1} >= FpayOverdueDay1 and FpayOverdueDay1 > {1}     THEN FpayOverdueAmount1 else 0 end) + (CASE  WHEN 2 * {1} >= FpayOverdueDay2 and FpayOverdueDay2 > {1}     THEN  FpayOverdueAmount2 else 0 end) + (CASE  WHEN 2 * {1} >= FpayOverdueDayDeadLine and FpayOverdueDayDeadLine > {1}     THEN FpayOverdueAmountDeadLine else 0 end) + (CASE  WHEN 2 * {1} >= FpayOverdueDayNoDate and FpayOverdueDayNoDate > {1}     THEN FpayOverdueAmountNoDate else 0 end)  FIntervalDay2
										, (CASE WHEN 3 * {1} >= FPrepayOverdueDay and FPrepayOverdueDay > 2 * {1} THEN FPrepayOverdueAmount else 0 end) + (CASE  WHEN 3 * {1} >= FPayInSendpayOverdueDay and FPayInSendpayOverdueDay > 2 * {1} THEN FPayInSendpayOverdueAmount else 0 end) + (CASE  WHEN 3 * {1} >= FpayOverdueDay1 and FpayOverdueDay1 > 2 * {1} THEN FpayOverdueAmount1 else 0 end) + (CASE  WHEN 3 * {1} >= FpayOverdueDay2 and FpayOverdueDay2 > 2 * {1} THEN  FpayOverdueAmount2 else 0 end) + (CASE  WHEN 3 * {1} >= FpayOverdueDayDeadLine and FpayOverdueDayDeadLine > 2 * {1} THEN FpayOverdueAmountDeadLine else 0 end) + (CASE  WHEN 3 * {1} >= FpayOverdueDayNoDate and FpayOverdueDayNoDate > 2 * {1} THEN FpayOverdueAmountNoDate else 0 end)  FIntervalDay3
										, (CASE WHEN 4 * {1} >= FPrepayOverdueDay and FPrepayOverdueDay > 3 * {1} THEN FPrepayOverdueAmount else 0 end) + (CASE  WHEN 4 * {1} >= FPayInSendpayOverdueDay and FPayInSendpayOverdueDay > 3 * {1} THEN FPayInSendpayOverdueAmount else 0 end) + (CASE  WHEN 4 * {1} >= FpayOverdueDay1 and FpayOverdueDay1 > 3 * {1} THEN FpayOverdueAmount1 else 0 end) + (CASE  WHEN 4 * {1} >= FpayOverdueDay2 and FpayOverdueDay2 > 3 * {1} THEN  FpayOverdueAmount2 else 0 end) + (CASE  WHEN 4 * {1} >= FpayOverdueDayDeadLine and FpayOverdueDayDeadLine > 3 * {1} THEN FpayOverdueAmountDeadLine else 0 end) + (CASE  WHEN 4 * {1} >= FpayOverdueDayNoDate and FpayOverdueDayNoDate > 3 * {1} THEN FpayOverdueAmountNoDate else 0 end)  FIntervalDay4
										, (CASE WHEN 5 * {1} >= FPrepayOverdueDay and FPrepayOverdueDay > 4 * {1} THEN FPrepayOverdueAmount else 0 end) + (CASE  WHEN 5 * {1} >= FPayInSendpayOverdueDay and FPayInSendpayOverdueDay > 4 * {1} THEN FPayInSendpayOverdueAmount else 0 end) + (CASE  WHEN 5 * {1} >= FpayOverdueDay1 and FpayOverdueDay1 > 4 * {1} THEN FpayOverdueAmount1 else 0 end) + (CASE  WHEN 5 * {1} >= FpayOverdueDay2 and FpayOverdueDay2 > 4 * {1} THEN  FpayOverdueAmount2 else 0 end) + (CASE  WHEN 5 * {1} >= FpayOverdueDayDeadLine and FpayOverdueDayDeadLine > 4 * {1} THEN FpayOverdueAmountDeadLine else 0 end) + (CASE  WHEN 5 * {1} >= FpayOverdueDayNoDate and FpayOverdueDayNoDate > 4 * {1} THEN FpayOverdueAmountNoDate else 0 end)  FIntervalDay5
										, (CASE WHEN 6 * {1} >= FPrepayOverdueDay and FPrepayOverdueDay > 5 * {1} THEN FPrepayOverdueAmount else 0 end) + (CASE  WHEN 6 * {1} >= FPayInSendpayOverdueDay and FPayInSendpayOverdueDay > 5 * {1} THEN FPayInSendpayOverdueAmount else 0 end) + (CASE  WHEN 6 * {1} >= FpayOverdueDay1 and FpayOverdueDay1 > 5 * {1} THEN FpayOverdueAmount1 else 0 end) + (CASE  WHEN 6 * {1} >= FpayOverdueDay2 and FpayOverdueDay2 > 5 * {1} THEN  FpayOverdueAmount2 else 0 end) + (CASE  WHEN 6 * {1} >= FpayOverdueDayDeadLine and FpayOverdueDayDeadLine > 5 * {1} THEN FpayOverdueAmountDeadLine else 0 end) + (CASE  WHEN 6 * {1} >= FpayOverdueDayNoDate and FpayOverdueDayNoDate > 5 * {1} THEN FpayOverdueAmountNoDate else 0 end)  FIntervalDay6
										, (CASE WHEN 7 * {1} >= FPrepayOverdueDay and FPrepayOverdueDay > 6 * {1} THEN FPrepayOverdueAmount else 0 end) + (CASE  WHEN 7 * {1} >= FPayInSendpayOverdueDay and FPayInSendpayOverdueDay > 6 * {1} THEN FPayInSendpayOverdueAmount else 0 end) + (CASE  WHEN 7 * {1} >= FpayOverdueDay1 and FpayOverdueDay1 > 6 * {1} THEN FpayOverdueAmount1 else 0 end) + (CASE  WHEN 7 * {1} >= FpayOverdueDay2 and FpayOverdueDay2 > 6 * {1} THEN  FpayOverdueAmount2 else 0 end) + (CASE  WHEN 7 * {1} >= FpayOverdueDayDeadLine and FpayOverdueDayDeadLine > 6 * {1} THEN FpayOverdueAmountDeadLine else 0 end) + (CASE  WHEN 7 * {1} >= FpayOverdueDayNoDate and FpayOverdueDayNoDate > 6 * {1} THEN FpayOverdueAmountNoDate else 0 end)  FIntervalDay7
										, (CASE WHEN 8 * {1} >= FPrepayOverdueDay and FPrepayOverdueDay > 7 * {1} THEN FPrepayOverdueAmount else 0 end) + (CASE  WHEN 8 * {1} >= FPayInSendpayOverdueDay and FPayInSendpayOverdueDay > 7 * {1} THEN FPayInSendpayOverdueAmount else 0 end) + (CASE  WHEN 8 * {1} >= FpayOverdueDay1 and FpayOverdueDay1 > 7 * {1} THEN FpayOverdueAmount1 else 0 end) + (CASE  WHEN 8 * {1} >= FpayOverdueDay2 and FpayOverdueDay2 > 7 * {1} THEN  FpayOverdueAmount2 else 0 end) + (CASE  WHEN 8 * {1} >= FpayOverdueDayDeadLine and FpayOverdueDayDeadLine > 7 * {1} THEN FpayOverdueAmountDeadLine else 0 end) + (CASE  WHEN 8 * {1} >= FpayOverdueDayNoDate and FpayOverdueDayNoDate > 7 * {1} THEN FpayOverdueAmountNoDate else 0 end)  FIntervalDay8
										, (CASE WHEN FPrepayOverdueDay > 8 * {1} THEN FPrepayOverdueAmount else 0 end) + (CASE  WHEN FPayInSendpayOverdueDay > 8 * {1} THEN FPayInSendpayOverdueAmount else 0 end) + (CASE  WHEN FpayOverdueDay1 > 8 * {1} THEN FpayOverdueAmount1 else 0 end) + (CASE  WHEN FpayOverdueDay2 > 8 * {1} THEN  FpayOverdueAmount2 else 0 end) + (CASE  WHEN FpayOverdueDayDeadLine > 8 * {1} THEN FpayOverdueAmountDeadLine else 0 end) + (CASE  WHEN FpayOverdueDayNoDate > 8 * {1} THEN FpayOverdueAmountNoDate else 0 end)  FHigherDay
										from (
										select A.*
											, case when FPrepayOverdueAmount > 0 then FPrepayOverdueDay2 else 0 end FPrepayOverdueDay
											, case when FPayInSendpayOverdueAmount > 0  then FPayInSendpayOverdueDay2 else 0 end FPayInSendpayOverdueDay
											, case when FpayOverdueAmount1 > 0  then FpayOverdueDay12 else 0 end FpayOverdueDay1
											, case when FpayOverdueAmount2 > 0  then FpayOverdueDay22 else 0 end FpayOverdueDay2
											, case when FpayOverdueAmountDeadLine > 0  then FpayOverdueDayDeadLine2 else 0 end FpayOverdueDayDeadLine
											, case when FpayOverdueAmountNoDate > 0  then FpayOverdueDayNoDate2 else 0 end FpayOverdueDayNoDate
											, DATEDIFF(DAY, FMaxEndDay, FLastPayDay) FOverdueDay
											from (
											select * 
												, (case when FExpireDate2 is not null then FExpireDate2 when FExpireDate1 is not null then FExpireDate1 when FExpireDateDeadLine is not null then FExpireDateDeadLine when FExpireDateNoDate is not null then FExpireDateNoDate when FPayInSendExpireDate is not null then FPayInSendExpireDate else FPrePayExpireDate end ) FMaxEndDay
												, (case when FAcceptAbleAmount > 0 then FPrePayExpireAmout - FPrePayBackAmount else 0 end) FPrepayOverdueAmount, DATEDIFF(DAY, A.FPrePayExpireDate, '{4}') FPrepayOverdueDay2
												, (case when FAcceptAbleAmount > 0 then FPayInSendPayExpireAmout - FPayInSendPayBackAmount else 0 end) FPayInSendpayOverdueAmount, DATEDIFF(DAY, A.FPayInSendExpireDate, '{4}') FPayInSendpayOverdueDay2
												, (case when FAcceptAbleAmount > 0 then FPayExpireAmout1 - FPayBackAmount1 else 0 end) FpayOverdueAmount1,  DATEDIFF(DAY, A.FExpireDate1, '{4}') FpayOverdueDay12
												, (case when FAcceptAbleAmount > 0 then FPayExpireAmout2 - FPayBackAmount2 else 0 end) FpayOverdueAmount2,  DATEDIFF(DAY, A.FExpireDate2, '{4}') FpayOverdueDay22
												, (case when FAcceptAbleAmount > 0 then FPayExpireAmoutDeadLine - FPayBackAmountDeadLine else 0 end) FpayOverdueAmountDeadLine,  DATEDIFF(DAY, A.FExpireDateDeadLine, '{4}') FpayOverdueDayDeadLine2
												, (case when FAcceptAbleAmount > 0 then FPayExpireAmoutNoDate - FPayBackAmountNoDate else 0 end) FpayOverdueAmountNoDate,  DATEDIFF(DAY, A.FExpireDateNoDate, '{4}') FpayOverdueDayNoDate2
												from (
												select *
													,O.F_QAZ_PREPAYRATE FPrePayRate, 0 FPrePayDate, case when O.F_QAZ_PREPAYRATE = 0 then null else A.FFirstDay end FPrePayExpireDate,  (A.F_QAZ_AMOUNT * O.F_QAZ_PREPAYRATE / 100) FPrePayExpireAmout, (case when A.F_QAZ_AMOUNT * O.F_QAZ_PREPAYRATE/100 > A.FBackAmount then A.FBackAmount else A.F_QAZ_AMOUNT * O.F_QAZ_PREPAYRATE/100 end) FPrePayBackAmount
													,O.F_QAZ_SENDRATE FPayInSendPayRate, 0 FPayInSendDate, case when O.F_QAZ_SENDRATE = 0 then null else A.FFirstDay end FPayInSendExpireDate, (A.F_QAZ_AMOUNT * O.F_QAZ_SENDRATE / 100) FPayInSendPayExpireAmout, (case when A.F_QAZ_AMOUNT * O.F_QAZ_PREPAYRATE/100 > A.FBackAmount then 0 else (case when A.F_QAZ_AMOUNT * O.F_QAZ_SENDALLRATE/100 < A.FBackAmount then A.F_QAZ_AMOUNT * O.F_QAZ_SENDRATE / 100 else A.FBackAmount - A.F_QAZ_AMOUNT * O.F_QAZ_PREPAYRATE/100 end) end) FPayInSendPayBackAmount
													,O.F_QAZ_RATE1 FPayPay1Rate, O.F_QAZ_ALLDAY1 FPayDate1,case when O.F_QAZ_RATE1 = 0 then null else  (case when O.F_QAZ_PAYWAY = '3' then DATEADD(day,O.F_QAZ_ALLDAY1,A.FFirstDay) when O.F_QAZ_PAYWAY = '2' then DATEADD(day,O.F_QAZ_ALLDAY1,A.F_QAZ_ARRIVALTIME) when O.F_QAZ_PAYWAY = '5' then DATEADD(day,O.F_QAZ_ALLDAY1,A.FDATE) end) end  FExpireDate1, (A.F_QAZ_AMOUNT * O.F_QAZ_RATE1 / 100) FPayExpireAmout1, (case when A.F_QAZ_AMOUNT * O.F_QAZ_SENDALLRATE/100 > A.FBackAmount then 0 else (case when A.F_QAZ_AMOUNT * O.F_QAZ_ALLRATE1/100 > A.FBackAmount then A.FBackAmount - A.F_QAZ_AMOUNT * O.F_QAZ_SENDALLRATE/100 else A.F_QAZ_AMOUNT * O.F_QAZ_RATE1 / 100 end) end) FPayBackAmount1
													,O.F_QAZ_RATE2 FPayPay2Rate, O.F_QAZ_ALLDAY2 FPayDate2,case when O.F_QAZ_RATE2 = 0 then null else  (case when O.F_QAZ_PAYWAY = '3' then DATEADD(day,O.F_QAZ_ALLDAY2,A.FFirstDay) when O.F_QAZ_PAYWAY = '2' then DATEADD(day,O.F_QAZ_ALLDAY2,A.F_QAZ_ARRIVALTIME) when O.F_QAZ_PAYWAY = '5' then DATEADD(day,O.F_QAZ_ALLDAY1,A.FDATE) end) end  FExpireDate2, (A.F_QAZ_AMOUNT * O.F_QAZ_RATE2 / 100) FPayExpireAmout2, (case when A.F_QAZ_AMOUNT * O.F_QAZ_ALLRATE1/100 > A.FBackAmount then 0 else (case when A.F_QAZ_AMOUNT * O.F_QAZ_ALLRATE2/100 > A.FBackAmount then A.FBackAmount - A.F_QAZ_AMOUNT * O.F_QAZ_ALLRATE1/100 else A.F_QAZ_AMOUNT * O.F_QAZ_RATE2 / 100 end) end) FPayBackAmount2
													,case when F_QAZ_PAYWAY = '4' then O.F_QAZ_LASTRATE else 0 end FPayPayDeadLineRate, 0 FPayDateDeadLine, case when F_QAZ_PAYWAY = '4' then O.F_QAZ_RECDATE else null end FExpireDateDeadLine, case when F_QAZ_PAYWAY = '4' then (A.F_QAZ_AMOUNT * O.F_QAZ_LASTRATE / 100) else 0 end FPayExpireAmoutDeadLine, case when F_QAZ_PAYWAY = '4' then (case when A.F_QAZ_AMOUNT * O.F_QAZ_SENDALLRATE/100 > A.FBackAmount then 0 else (case when A.F_QAZ_AMOUNT > A.FBackAmount then A.FBackAmount - A.F_QAZ_AMOUNT * O.F_QAZ_SENDALLRATE/100 else A.F_QAZ_AMOUNT * O.F_QAZ_LASTRATE / 100 end) end) else 0 end FPayBackAmountDeadLine
													,case when F_QAZ_PAYWAY = '1' then O.F_QAZ_LASTRATE else 0 end FPayPayNoDateLineRate, 0 FPayDateNoDate, case when F_QAZ_PAYWAY = '1' then A.FEndDay1 else null end FExpireDateNoDate, case when F_QAZ_PAYWAY = '1' then (A.F_QAZ_AMOUNT * O.F_QAZ_LASTRATE / 100) else 0 end FPayExpireAmoutNoDate, case when F_QAZ_PAYWAY = '1' then (case when A.F_QAZ_AMOUNT * O.F_QAZ_SENDALLRATE/100 > A.FBackAmount then 0 else (case when A.F_QAZ_AMOUNT > A.FBackAmount then A.FBackAmount - A.F_QAZ_AMOUNT * O.F_QAZ_SENDALLRATE/100 else A.F_QAZ_AMOUNT * O.F_QAZ_LASTRATE / 100 end) end) else 0 end FPayBackAmountNoDate
													,case when O.F_QAZ_PAYWAY = '2' then (A.F_QAZ_AMOUNT * O.F_QAZ_LASTRATE / 100) else 0 end FPayExpireAmoutNoMatch  
													from 
													(
														select A.FEntryID, B.FCUSTTYPEID, Z.FDATE, case when A.F_QAZ_ACTUALAMOUNT > 0 then A.F_QAZ_ACTUALAMOUNT else A.F_QAZ_AMOUNT end F_QAZ_AMOUNT,A.F_QAZ_BASE,P.FLastPayDay,Z.F_QAZ_ARRIVALTIME,
														A.F_QAZ_TEXT FArea,D.FNAME FSaler,C.FNAME FCustomer,A.F_QAZ_REMARK1 FProject,A.FNUMBER FContract,E.FNAME FReceive,A.F_QAZ_DATE FContractDate, A.F_QAZ_AMOUNT FContractAmount
														,isnull(F.zfhje,0) FSendAmount,isnull(Y.jshj, 0) FReturnAmount, isnull(G.zysdje,0)+isnull(H.zqtysje,0) FAcceptAmount,isnull(T0.contractionAmount,0) - isnull(I.whx,0) FBackAmount,
														isnull(G.zysdje,0)+isnull(H.zqtysje,0)-(isnull(T0.contractionAmount,0) - isnull(I.whx,0)) FAcceptAbleAmount,isnull(isnull(isnull(N.FNAME, N1.FNAME), N2.FNAME), N3.FNAME) FSettleOrg,F.FFirstDay, Z.FDATE FEndDay, F.FEndDay FEndDay1,isnull(isnull(isnull(L.FNAME, L1.FNAME), L2.FNAME), L3.FNAME) FCurrency
														from T_BAS_ASSISTANTDATAENTRY A
														left join T_BD_CUSTOMER B on A.F_QAZ_BASE2=B.FMASTERID
														left join T_BD_CUSTOMER_L C on A.F_QAZ_BASE2=C.FCUSTID and C.FLOCALEID=2052
														left join T_HR_EMPINFO K on K.FID = A.F_QAZ_BASE1
														left join T_HR_EMPINFO_L D on A.F_QAZ_BASE1=D.FID and D.FLOCALEID=2052
														left join T_BD_RecCondition_L E on A.F_QAZ_BASE=E.FID and E.FLOCALEID=2052
														left join 
														(
															select hth,sum(FALLAMOUNT) zfhje,sum(F_QAZ_KPJE) zkpje,FSETTLEORGID zz, max(FSETTLECURRID) FSETTLECURRID, min(FDATE) FFirstDay, max(FDATE) FEndDay from
															(
																select B.FNUMBER hth,D.FALLAMOUNT,D.FALLAMOUNT_LC,G.FSETTLEORGID,G.FSETTLECURRID,CONVERT(decimal, C.F_QAZ_KPJE) F_QAZ_KPJE, A.FDATE from T_SAL_OUTSTOCK A
																left join T_BAS_ASSISTANTDATAENTRY B on A.F_QAZ_ASSISTANT1=B.FENTRYID and B.fid='5d14472db259d7'
																left join T_SAL_OUTSTOCKENTRY C on A.FID=C.FID
																left join T_SAL_OUTSTOCKENTRY_F D on C.FID=D.FID and C.FENTRYID=D.FENTRYID
																left join T_SAL_OUTSTOCKFIN G on A.FID=G.FID
																where A.FDOCUMENTSTATUS='C' and FCANCELSTATUS='A' and G.FISGENFORIOS = '0' and A.FDATE <= '{4}'
															) A group by hth,FSETTLEORGID 
														)F on F.hth=A.FNUMBER
														left join
														(
															select C.FNUMBER,sum(B.FBILLALLAMOUNT) jshj from T_SAL_RETURNSTOCK A 
															inner join T_SAL_RETURNSTOCKFIN B on A.FID = B.FID
															left join T_BAS_ASSISTANTDATAENTRY C on A.F_QAZ_ASSISTANT1=C.FENTRYID and C.fid='5d14472db259d7' group by C.FNUMBER
														) Y on Y.FNUMBER=A.FNUMBER
														left join (
															select B.FNUMBER, sum(T0.contractionAmount) contractionAmount, T0.FPAYORGID, T0.FSETTLECUR from (
																select T0.FRECTOTALAMOUNTFOR contractionAmount, T0.F_QAZ_ASSISTANT contraction, T2.FPAYORGID, T2.FSETTLECUR from T_AR_RECEIVEBILLENTRY T0 inner join T_AR_RECEIVEBILL T2 on T0.FID = T2.FID where T0.F_QAZ_ISSPLIT = '0' and T2.FDATE <= '{4}' and T2.FDOCUMENTSTATUS='C' and T2.FCANCELSTATUS='A'
																union all
																select T1.F_QAZ_SPLITAMOUNT contractionAmount, T1.F_QAZ_SPLITCONTRACTION contraction, T2.FPAYORGID, T2.FCURRENCYID from T_AR_RECEIVEBILLENTRY T0
																inner join T_AR_RECEIVEBILL T2 on T0.FID = T2.FID 
																inner join qaz_t_Cust_Entry100019 T1 on T0.FENTRYID = T1.FEntryID where T0.F_QAZ_ISSPLIT = '1' and T2.FDATE <= '{4}' and T2.FDOCUMENTSTATUS='C' and T2.FCANCELSTATUS='A'
															) T0 inner join  T_BAS_ASSISTANTDATAENTRY B on T0.contraction=B.FENTRYID and B.fid='5d14472db259d7' group by B.FNUMBER, T0.FPAYORGID, T0.FSETTLECUR
														) T0 on T0.FNUMBER = A.FNUMBER
														left join 
														(
															select B.FNUMBER, A.FDATE, A.F_QAZ_ARRIVALTIME from T_SAL_OUTSTOCK A
															left join T_BAS_ASSISTANTDATAENTRY B on A.F_QAZ_ASSISTANT1=B.FENTRYID and B.fid='5d14472db259d7'  where F_QAZ_ISLASTOUT = '1'
															and A.FDOCUMENTSTATUS='C' and FCANCELSTATUS='A' and A.FDATE <= '{4}'
														) Z on Z.FNUMBER=A.FNUMBER
														left join
														(
															select jszz,hth,max(FCURRENCYID)FCURRENCYID,sum(FPAYAMOUNTFOR) zysdje,sum(FWRITTENOFFAMOUNTFOR)zyshx from
															(
																select A.FSETTLEORGID jszz,A.FCURRENCYID,B.FNUMBER hth,C.FPAYAMOUNTFOR,C.FWRITTENOFFAMOUNTFOR from t_AR_receivable A
																left join T_BAS_ASSISTANTDATAENTRY B on A.F_QAZ_ASSISTANT1=B.FENTRYID and B.fid='5d14472db259d7'
																left join t_AR_receivablePlan C on A.FID=C.FID
																where A.FDOCUMENTSTATUS='C' and A.FCANCELSTATUS='A' and B.FNUMBER is not null and A.FDATE <= '{4}'
															)A group by jszz,hth
														)G on G.hth=A.FNUMBER and G.jszz=F.zz
														left join
														(
															select jszz,hth,FCURRENCYID,sum(FAMOUNTFOR) zqtysje,sum(FWRITTENOFFAMOUNTFOR)zqtyshx from
															(
																select A.FSETTLEORGID jszz,B.FNUMBER hth,A.FAMOUNTFOR,A.FWRITTENOFFAMOUNTFOR, A.FCURRENCYID from T_AR_OtherRecAble A
																left join T_BAS_ASSISTANTDATAENTRY B on A.F_QAZ_ASSISTANT1=B.FENTRYID and B.fid='5d14472db259d7'
																where A.FDOCUMENTSTATUS='C' and A.FCANCELSTATUS='A' and B.FNUMBER is not null and A.FDATE <= '{4}'
															)A group by jszz,hth,FCURRENCYID
														)H on H.hth=A.FNUMBER
														left join
														(
															select jszz,hth,sum(whx) whx, max(FSETTLECUR) FSETTLECUR from
															(
																select A.FSETTLEORGID jszz,B.FNUMBER hth,C.FREFUNDAMOUNTFOR as whx, A.FSETTLECUR from T_AR_REFUNDBILL A
																left join T_AR_REFUNDBILLENTRY C on A.FID=C.FID
																left join T_BAS_ASSISTANTDATAENTRY B on C.F_QAZ_ASSISTANT=B.FENTRYID and B.fid='5d14472db259d7'
																where A.FDOCUMENTSTATUS='C' and A.FCANCELSTATUS='A' and B.FNUMBER is not null and (A.FDATE <= '{4}')
															)A group by jszz,hth
														)I on I.hth=A.FNUMBER
														left join
														(
															select jszz,hth,max(FDATE) FLastPayDay from
															(
																select A.FSETTLEORGID jszz,B.FNUMBER hth,C.FRECTOTALAMOUNTFOR-C.FWRITTENOFFAMOUNTFOR as whx, A.FDATE from T_AR_RECEIVEBILL A
																left join T_AR_RECEIVEBILLENTRY C on A.FID=C.FID
																left join T_BAS_ASSISTANTDATAENTRY B on C.F_QAZ_ASSISTANT=B.FENTRYID and B.fid='5d14472db259d7'
																where A.FDOCUMENTSTATUS='C' and A.FCANCELSTATUS='A' and B.FNUMBER is not null and A.FDATE <= '{4}'
																union all
																select A.FSETTLEORGID jszz,B.FNUMBER hth,C.FWRITTENOFFAMOUNTFOR-C.FREFUNDAMOUNTFOR as whx, null FDATE from T_AR_REFUNDBILL A
																left join T_AR_REFUNDBILLENTRY C on A.FID=C.FID
																left join T_BAS_ASSISTANTDATAENTRY B on C.F_QAZ_ASSISTANT=B.FENTRYID and B.fid='5d14472db259d7'
																where A.FDOCUMENTSTATUS='C' and A.FCANCELSTATUS='A' and B.FNUMBER is not null and A.FDATE <= '{4}'
															)A group by jszz,hth
														)P on P.hth=A.FNUMBER
														left join T_ORG_Organizations J on J.FOrgID = F.zz
														left join T_ORG_Organizations_L N on N.FOrgID = F.zz and N.FLOCALEID=2052
														left join T_BD_CURRENCY_L L on F.FSETTLECURRID=L.FCURRENCYID and L.FLOCALEID=2052
														left join T_BD_CURRENCY M on F.FSETTLECURRID=M.FCURRENCYID

														left join T_ORG_Organizations J1 on J1.FOrgID = I.jszz
														left join T_ORG_Organizations_L N1 on N1.FOrgID = I.jszz and N1.FLOCALEID=2052
														left join T_BD_CURRENCY_L L1 on I.FSETTLECUR=L1.FCURRENCYID and L1.FLOCALEID=2052
														left join T_BD_CURRENCY M1 on I.FSETTLECUR=M1.FCURRENCYID
	
														left join T_ORG_Organizations J2 on J2.FOrgID = T0.FPAYORGID
														left join T_ORG_Organizations_L N2 on N2.FOrgID = T0.FPAYORGID and N2.FLOCALEID=2052
														left join T_BD_CURRENCY_L L2 on T0.FSETTLECUR=L2.FCURRENCYID and L2.FLOCALEID=2052
														left join T_BD_CURRENCY M2 on T0.FSETTLECUR=M2.FCURRENCYID
	
														left join T_ORG_Organizations J3 on J3.FOrgID = H.jszz
														left join T_ORG_Organizations_L N3 on N3.FOrgID = H.jszz and N3.FLOCALEID=2052
														left join T_BD_CURRENCY_L L3 on H.FCURRENCYID=L3.FCURRENCYID and L3.FLOCALEID=2052
														left join T_BD_CURRENCY M3 on H.FCURRENCYID=M3.FCURRENCYID
	
														where A.fid='5d14472db259d7' and A.F_QAZ_CHECKBOX=1 {8}
													) A
													left join T_BD_RecCondition O on A.F_QAZ_BASE = O.FID {9}
												) A 
											) A where A.FArea like '%{5}%' and A.FContract like '%{6}%' and A.FProject like '%{7}%'
										)A
									) A left join {3} B on A.FContract = B.FReceiveContract where {10}
								";

			strSQL = string.Format(strSQL,
				tableName,                                //{0}
				reportFilter.DynamicStep,                 //{1}
				reportFilter.StaticStep,                  //{2}
				tmpTable,                                 //{3}
				reportFilter.StaticDate,                  //{4}
				reportFilter.Area,                        //{5}
				reportFilter.Contract,                    //{6}
				reportFilter.Project,                     //{7}
				filterStr,                                //{8}
				string.IsNullOrWhiteSpace(reportFilter.CustTypeId)?"": $" where FCUSTTYPEID = '{reportFilter.CustTypeId}'", //{9}
				outFilterStr  //{10}
				);
			Logger.Info("ReportServerPlugin", strSQL);
			DBUtils.Execute(base.Context, strSQL);
            string delete =$@"/*dialect*/delete from {tableName} where FEntryID in (select F_CONTRACT from qaz_t_Amountdue where FDISABLE='A')";
			DBUtils.Execute(base.Context, delete);
			string sql = $@"/*dialect*/update {tableName} set FExpireDate2=CONVERT(varchar, F_EXPRIREDATE, 23),FPayExpireAmout2=F_AMOUNTDUE from 
								{tableName},qaz_t_Amountdue
								where {tableName}.FEntryID=qaz_t_Amountdue.F_CONTRACT								";
			DBUtils.Execute(base.Context, sql);
		}

		protected override string GetIdentityFieldIndexSQL(string tableName)
		{
			return "";
		}
	}
}
