﻿using Kingdee.BOS;
using Kingdee.BOS.Contracts.Report;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Core.List.PlugIn;
using Kingdee.BOS.Core.List.PlugIn.Args;
using Kingdee.BOS.Core.Metadata;
using Kingdee.BOS.Core.Report;
using Kingdee.BOS.Core.SqlBuilder;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.ServiceHelper;
using Kingdee.BOS.Util;
using Kingdee.K3.Core.MFG;
using Kingdee.K3.Core.MFG.EntityHelper;
using Kingdee.K3.MFG.ServiceHelper;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;

namespace LF.K3.SCM.BusinessPlugin
{
    [Description("磊飞任务表过滤")]
    [HotUpdate]
    public class BomTaskFilter : AbstractListPlugIn
    {
        int GV = 0;
        public override void PrepareFilterParameter(FilterArgs e)
        {
            base.PrepareFilterParameter(e);

            //定义过滤条件的字符串
            string filterString = "";
            if (GV == 2)
            {
                
                    //加载的时候,获取发布主控台设置的参数ListSet,My
                string listType1 = this.View.OpenParameter.GetCustomParameter("ListSetALL") as string;

                //判断字符串 listType的值是否为空,或者为空格,与My,不区分大小写对比
                if (!string.IsNullOrWhiteSpace(listType1) && listType1.Equals("ALL", StringComparison.OrdinalIgnoreCase))
                {
                    //创建人ID等于登录用户ID
                    filterString = string.Format("FID is not  null");

                }
                //原本的过滤条件e.FilterString
                if (!string.IsNullOrWhiteSpace(e.FilterString) && !string.IsNullOrWhiteSpace(filterString))
                {
                    e.FilterString += "AND";
                }
            }
            else
            {
                //加载的时候,获取发布主控台设置的参数ListSet,My
                string listType = this.View.OpenParameter.GetCustomParameter("ListSet") as string;

                //判断字符串 listType的值是否为空,或者为空格,与My,不区分大小写对比
                if (!string.IsNullOrWhiteSpace(listType) && listType.Equals("My", StringComparison.OrdinalIgnoreCase))
                {
                    //创建人ID等于登录用户ID
                    filterString = string.Format("FID in (SELECT FID FROM T_BOMpersoniable where FPERSONLIABLE={0})", this.Context.UserId);

                }
                //原本的过滤条件e.FilterString
                if (!string.IsNullOrWhiteSpace(e.FilterString) && !string.IsNullOrWhiteSpace(filterString))
                {
                    e.FilterString += "AND";
                }
            }
            e.FilterString += filterString;


        }

        public override void BarItemClick(BarItemClickEventArgs e)
        {
            base.BarItemClick(e);
            //点击查看全部
            if (e.BarItemKey == "btnSelAll")
            {
                GV = 2;
                this.View.Refresh();
            }
            //点击查看我的
            if (e.BarItemKey == "btnSelMy")
            {
                GV = 1;
                this.View.Refresh();
            }
        }

    }
}
