﻿using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Core.List;
using Kingdee.BOS.Core.List.PlugIn;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.ServiceHelper;
using Kingdee.BOS.Util;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LQKJ.DANGAN.ReportPlugIN
{
    [HotUpdate, Description("列表插件更新，档案查阅次数")]
    public class NumberVisitsListPlugIN: AbstractListPlugIn
    {
        public override void OnInitialize(InitializeEventArgs e)
        {
            LoadDate();
        }

        private void LoadDate()
        {
            string sql = @"/*dialect*/update T_LQKJ_FilesManage set FCYCount=(select COUNT(*) from T_DA_ArchiveAccess where FDAIDCARD=t1.FDAIDCARD) from T_DA_ArchiveAccess t1,T_LQKJ_FilesManage t2 where t1.FDAIDCARD = t2.FIDCARD and t1.FFORBIDSTATUS = 'A' and t1.FHANDLESTATES = 'Y'";
            DBUtils.Execute(this.Context, sql);
        }
    }
}
