﻿using Kingdee.BOS.Core.Bill.PlugIn;
using Kingdee.BOS.Core.Bill.PlugIn.Args;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Core.Metadata;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.ServiceHelper;
using Kingdee.BOS.Util;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LQKJ.NDR.ReportPlug
{
    [HotUpdate, Description("表单插件,工作日历时间")]
    public class CalendarInsetReportPlug : AbstractBillPlugIn
    {
        public override void AfterBindData(EventArgs e)
        {
            base.AfterBindData(e);
            //判断单据的状态是否为新增
            if (!this.View.OpenParameter.Status.Equals(OperationStatus.ADDNEW))
            {

            }
            
        }
        public override void ButtonClick(ButtonClickEventArgs e)
        {
            base.ButtonClick(e);
            if (e.Key.ToUpper().Equals("FButton".ToUpper()))
            {
                if (!this.View.OpenParameter.Status.Equals(OperationStatus.ADDNEW))
                {
                    this.View.ShowErrMessage("仅新增状态下可用！");
                    return;//不为新增
                }
                var Year = this.View.Model.GetValue("FYear");
                if (string.IsNullOrWhiteSpace(Year?.ToString()))
                {
                    this.View.ShowErrMessage("年份不能为空！");
                    return;//不为新增
                }
                GeneratedData(int.Parse(DateTime.Parse(Year.ToString()).ToString("yyyy")));
            }
        }
        private void GeneratedData(int year)
        {
            // 获取单据体数据包
            DynamicObjectCollection Entrys = this.View.Model.DataObject["LQKJ_Cust_CalendarEntry"] as DynamicObjectCollection;
            Entrys.Clear();
            DateTime startDate = new DateTime(year, 1, 1);
            DateTime endDate = new DateTime(year, 12, 31);
            for (DateTime date = startDate; date <= endDate; date = date.AddDays(1))
            {
                //创建新的单据体分录行
                DynamicObject entry = Entrys.DynamicCollectionItemPropertyType.CreateInstance() as DynamicObject;
                entry["FDate"] = date.ToString("yyyy-MM-dd");//FDateType
                if (date.DayOfWeek == DayOfWeek.Saturday || date.DayOfWeek == DayOfWeek.Sunday)
                {
                    entry["FDateType"] = 2;
                }
                else
                {
                    entry["FDateType"] = 1;
                }
                Entrys.Add(entry);
            }
            // 重新加载数据包
            DBServiceHelper.LoadReferenceObject(this.Context, Entrys.ToArray(), Entrys.FirstOrDefault().DynamicObjectType, false);
            this.View.UpdateView("F_LQKJ_CalendarEntry");
        }
    }
}
