﻿using Kingdee.BOS;
using Kingdee.BOS.Core.Bill.PlugIn;
using Kingdee.BOS.Core.Bill.PlugIn.Args;
using Kingdee.BOS.Core.DynamicForm.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Core.DynamicForm.PlugIn.ControlModel;
using Kingdee.BOS.Core.List.PlugIn;
using Kingdee.BOS.Core.Metadata;
using Kingdee.BOS.Core.Permission;
using Kingdee.BOS.JSON;
using Kingdee.BOS.ServiceHelper.FileServer;
using Kingdee.BOS.Util;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web;
using LQKJ.XIBU.Core;
using Kingdee.BOS.Core;
using System.Threading;
using Kingdee.BOS.Core.Metadata.FieldElement;
using static Kingdee.BOS.App.Core.Validation.EntryEntity.CompositePKValidator.KeyHelper;
using System.Reflection;

namespace LQKJ.NSJYB.ReportPlug
{
    [HotUpdate, Description("嵌入网页")]
    public class InlayHtml: AbstractBillPlugIn
    {
        private int count=0;
        private string url = Kingdee.BOS.KDConfiguration.Current.CommonConfiguration.AppSettings.Settings["url"].Value;

        public override void AfterBindData(EventArgs e)
        {

            base.AfterBindData(e);
            string webSiteUrl = FileServerHelper.GetAppSiteOuterNetUrl(this.Context, HttpContext.Current.Request);
            string FormId = this.View.GetFormId();
            string FID = this.View.Model.DataObject["Id"].ToString();
            string UserId = this.Context.UserId.ToString();

            string sourceUrl = string.Format($"http://192.168.1.168:85/#/RichTextEditor?FormId={FormId}&FID={FID}&UserID={UserId}");
            //string sourceUrl = string.Format($"http://192.168.1.42:4000/#/RichTextEditor?FormId={FormId}&FID={FID}&UserID={UserId}");
            //拿到面板控件，设置需要展示的嵌套网页地址，参数通过url传参。
            Control webBrowse = this.View.GetControl("FRichTextPanel");
            webBrowse.SetCustomPropertyValue("Source", sourceUrl);
            webBrowse.SetCustomPropertyValue("IsSetBrowseVisible", true);
            webBrowse.SetCustomPropertyValue("Allowfullscreen", true);

            //兼容GUI。
            if (this.View.Context.ClientType != ClientType.Silverlight
                && this.View.Context.ClientType != ClientType.Html)
            {
                webBrowse.InvokeControlMethod("StartTime", 1);
            }
            this.View.AddAction("notShowMainFormHolder", true);
        }
        public override void BeforeClosed(BeforeClosedEventArgs e)
        {
            string UserId = this.Context.UserId.ToString();
            if (RichText.RihTextKeys.ContainsKey(UserId))
            {
                RichText.RihTextKeys.Remove(UserId);
            }
        }
        /*public override void CustomEvents(CustomEventsArgs e)
        {
            //判断是嵌套网页发起的自定义事件，才执行相关逻辑。
            if (e.EventName.EqualsIgnoreCase("$$MessageCustomerEvent".Trim()))
            {
                //拿到嵌套网页传递过来的JSON数据。
                JSONObject data = JSONObject.Parse(e.EventArgs);
                string content = data.GetValue("content", string.Empty);
                this.View.ShowMessage(content);

                //消息提示完隐藏WebBrowse，兼容WPF。
                Control webBrowse = this.View.GetControl("FRichTextPanel");
                //webBrowse.SetCustomPropertyValue("IsBrowserVisible", false);
            }
        }*/
        public override void BeforeSave(BeforeSaveEventArgs e)
        {
            base.BeforeSave(e);
            Thread.Sleep(1000);
            string UserId = this.Context.UserId.ToString();
            if (!RichText.RihTextKeys.ContainsKey(UserId))
            {
                if (count == 0)
                {
                    this.View.ShowWarnningMessage
                    ("无法保存富文本内容，服务器异常,请确认",
                    action: (result) =>
                    {
                        count++;
                        this.View.Model.Save();
                    }
                    );
                    e.Cancel = true;
                }
            }
            else
            {
                var field = (LargeTextField)this.View.BillBusinessInfo.GetField("FRichText");
                field.TagDynamicProperty.SetValue(this.View.Model.DataObject, RichText.RihTextKeys[UserId].GetUtf8Bytes());
                this.View.UpdateView("FRichText");
                //this.View.Model.SetValue("FRichText", RichText.RihTextKeys[UserId]);
                //RichText.RihTextKeys.Remove(UserId);    
            }
        }
    }
}
