﻿using Kingdee.BOS.Core.Bill.PlugIn;
using Kingdee.BOS.Core.Bill.PlugIn.Args;
using Kingdee.BOS.Core.Metadata;
using Kingdee.BOS.Util;
using LQKJ.LicVerify;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LQKJ.DANGAN.ReportPlugIN
{
    [HotUpdate, Description("表单插件，查阅预约")]
    ///查阅预约新增时自动添加预约时间
    public class CheckAppointments : AbstractBillPlugIn
    {
        public override void AfterSave(AfterSaveEventArgs e)
        {
            if (!LicScheduler.LicVerify())
                throw new Exception("lic过期");
            base.AfterBindData(e);
            if (this.View.OpenParameter.Status.Equals(OperationStatus.ADDNEW))
            {
                this.View.Model.SetValue("FDatetime", DateTime.Now.ToString("yyyy-MM-dd HH:ss"));
                this.View.UpdateView("FDatetime");
            }
        }
    }
}
