﻿using Kingdee.BOS.Core.Bill.PlugIn;
using Kingdee.BOS.Core.Bill.PlugIn.Args;
using Kingdee.BOS.Core.DynamicForm;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Core.List.PlugIn;
using Kingdee.BOS.Core.Metadata;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.ServiceHelper;
using Kingdee.BOS.Util;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using LQKJ.LicVerify;

namespace LQKJ.DANGAN.ReportPlugIN
{
    [HotUpdate, Description("表单插件,打开定制结算单日期选择动态表单")]
    public class GeneratingDocuments: AbstractListPlugIn
    {
        public override void BarItemClick(BarItemClickEventArgs e)
        {
            if (!LicScheduler.LicVerify())
                throw new Exception("lic过期");
            if (e.BarItemKey.Equals("LButton"))
            {   //调用,动态表单
                //var model = this.View.Model;
                DynamicFormShowParameter form = new DynamicFormShowParameter();
                //调用哪个表单
                form.FormId = "LQKJ_SettlementFiltering";
                //form.CustomParams.Add("FBillNo", Convert.ToString(this.View.Model.GetValue("FBillNo")));
                //打开的动态表单,加载进来
                this.View.ShowForm(form, new Action<FormResult>((results) =>
                {
                    var count = results.ReturnData;
                    if (count != null)
                    {
                        this.View.ShowMessage($"共生成{count}个街道的费用结算单！");
                        this.View.Refresh();
                    }
                    
                }));
            }

        }
    }
}
