﻿using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Core.List;
using Kingdee.BOS.Core.List.PlugIn;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.Orm.Metadata.DataEntity;
using Kingdee.BOS.ServiceHelper;
using Kingdee.BOS.Util;
using LQKJ.LicVerify;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;


namespace LQKJ.DANGAN.ReportPlugIN
{
    [HotUpdate, Description("列表插件更新，干预套打数据")]
    public class IntervenePrintListPlugin : AbstractListPlugIn
    {
        public override void OnPrepareNotePrintData(PreparePrintDataEventArgs e)
        {
            if (!LicScheduler.LicVerify())
                throw new Exception("lic过期");
            base.OnPrepareNotePrintData(e);
            //var FAnnual = this.View.Model.GetValue("FND")?.ToString();
            if (e.DataSourceId != "FEntity")
                return;
            switch (e.NotePrintTplId)
            {
                case "69299298-a6be-4609-8eda-49ef35ca540e":
                    QuarterSummaryTemplate(e);
                    break;
            }
        }
        public void QuarterSummaryTemplate(PreparePrintDataEventArgs e)
        {
            string FID = e.BillIds[0];
            string Sql = $"select FStreet,FStartDate,FEndDate from LQKJ_t_Cust100025 where FID={FID}";
            DataTable data1 = DBServiceHelper.ExecuteDataSet(this.Context, Sql).Tables[0];
            var FStartDate = data1.Rows[0]["FStartDate"];//开始时间
            var FEndDate = data1.Rows[0]["FEndDate"];//结束时间
            var FStreet = data1.Rows[0]["FStreet"];//街道
            //DataTable data = GetQuarterData(FAnnual, FQuarter);
            DynamicObject obj = new DynamicObject(e.DynamicObjectType);
            List<DynamicObject> result = new List<DynamicObject>();
            //单据体动态字段注册
            List<string> DynamicFieldsList = new List<string>() {"FBillNos", "FFileCabinetNumber", "FGroupAffiliation", "FhandedOverCompanies", "FStreetss", "FCommunity", "FNames",
                "FSex","FPhones", "FIDCards", "FISParty","FPartyLocation", "FEnterpriseQuality","FReceiptDate", "FTransferringParty","FModifyScenario", "F_LQKJ_CreateDates", "F_LQKJ_ModifyDates","AddIS"};
            DynamicObject eData = e.DataObjects[0];
            foreach (var Field in DynamicFieldsList)
            {
                DynamicFieldsEnroll(Field, eData);
            }
            string sql = $@"/*dialect*/WITH RankedArchives AS (
                                SELECT
                                    FBillNo,FFileCabinetNumber,FGroupAffiliation,FhandedOverCompanies,FStreet,FCommunity,FName,FSex,FIDCard,FPhone,FISParty,FPartyLocation,FEnterpriseQuality,FReceiptDate,FTransferringParty,
                            		FModifyScenario,
                            		F_LQKJ_CreateDate,F_LQKJ_ModifyDate,CASE WHEN FReceiptDate >='{FStartDate}' AND FReceiptDate<='{FEndDate}'THEN '@Condition' ELSE '' END as AddIS,
                                    ROW_NUMBER() OVER (PARTITION BY FIDCard ORDER BY FBillNo) AS ArchiveRank
                                FROM
                                    T_LQKJ_FilesManage
                            		where FDOCUMENTSTATUS='C' and FINVALIDATEDSTATUS='A' and FSTREET='{FStreet}'
                            )
                            SELECT
                                *
                            FROM
                                RankedArchives
                            WHERE
                            ArchiveRank = 1 order by FBILLNO desc;";
            DataTable data = DBServiceHelper.ExecuteDataSet(this.Context, sql).Tables[0];
            for (int i = 0; i < data.Rows.Count; i++)
            {
                //if()
                obj["FBillNos"] = data.Rows[i]["FBillNo"];
                obj["FFileCabinetNumber"] = data.Rows[i]["FFileCabinetNumber"];
                obj["FGroupAffiliation"] = data.Rows[i]["FGroupAffiliation"];
                obj["FhandedOverCompanies"] = data.Rows[i]["FhandedOverCompanies"];
                obj["FStreetss"] = data.Rows[i]["FStreet"];
                obj["FCommunity"] = data.Rows[i]["FCommunity"];
                obj["FNames"] = data.Rows[i]["FName"];
                obj["FSex"] = data.Rows[i]["FSex"]?.ToString() == "0" ? "男" : "女";
                obj["FIDCards"] = data.Rows[i]["FIDCard"];
                obj["FPhones"] = data.Rows[i]["FPhone"];
                obj["FISParty"] = data.Rows[i]["FISParty"]?.ToString() == "0" ? "否" : "是";
                obj["FPartyLocation"] = data.Rows[i]["FPartyLocation"];
                obj["FEnterpriseQuality"] = data.Rows[i]["FEnterpriseQuality"];
                obj["FReceiptDate"] = data.Rows[i]["FReceiptDate"];
                obj["FTransferringParty"] = data.Rows[i]["FTransferringParty"];
                obj["FModifyScenario"] = data.Rows[i]["FModifyScenario"];
                obj["F_LQKJ_CreateDates"] = data.Rows[i]["F_LQKJ_CreateDate"];
                obj["F_LQKJ_ModifyDates"] = data.Rows[i]["F_LQKJ_ModifyDate"];
                obj["AddIS"] = data.Rows[i]["AddIS"];
                result.Add(obj);
                obj = new DynamicObject(e.DynamicObjectType);
            }
            DBServiceHelper.LoadReferenceObject(this.Context, result.ToArray(), e.DynamicObjectType);
            e.DataObjects = result.ToArray();
        }

        /// <summary>
        /// 动态字段注册赋值
        /// </summary>
        public void DynamicFieldsEnroll(string logotype, DynamicObject eData)
        {
            DynamicObjectType dot = eData.DynamicObjectType;
            dot.RegisterSimpleProperty(
            logotype,
            typeof(object),
            attributes: new SimplePropertyAttribute() { Alias = logotype }
            );
        }

    }
}
