﻿using Kingdee.BOS.Core.Bill.PlugIn;
using Kingdee.BOS.Core.Bill.PlugIn.Args;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Core.Metadata;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.ServiceHelper;
using Kingdee.BOS.Util;
using LQKJ.LicVerify;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LQKJ.DANGAN.ReportPlugIN
{
    [HotUpdate, Description("表单插件,新增预约时间信息")]
    public class YuYueGuiZeReportPlugIN : AbstractBillPlugIn
    {

        public override void AfterBindData(EventArgs e)
        {
            if (!LicScheduler.LicVerify())
                throw new Exception("lic过期");
            base.AfterBindData(e);
            //判断单据的状态是否为新增
            if (!this.View.OpenParameter.Status.Equals(OperationStatus.ADDNEW))
            {
                return;
            }
            // 获取单据体数据包
            DynamicObjectCollection Entrys = this.View.Model.DataObject["DA_RuleInformation"] as DynamicObjectCollection;
            Entrys.Clear();
            DateTime StateTime = new DateTime(2023, 9, 26, 9, 30, 0);
            DateTime EndTime = new DateTime(2023, 9, 26, 16, 30, 0);
            for (; StateTime <= EndTime; StateTime = StateTime.AddMinutes(60))
            {
                if (StateTime.Hour == 11||StateTime.Hour == 12 || StateTime.Hour == 13)
                    continue;
                //创建新的单据体分录行
                DynamicObject entry = Entrys.DynamicCollectionItemPropertyType.CreateInstance() as DynamicObject;
                entry["F_LQKJ_MakeTime"] = StateTime.ToString("HH:mm:ss");
                entry["F_LQKJ_EndTime"] = StateTime.AddMinutes(60).ToString("HH:mm:ss");
                entry["FPlacesNumber"] = 1;
                entry["FRemainderNumber"] = 1;
                Entrys.Add(entry);
            }
            // 重新加载数据包
            DBServiceHelper.LoadReferenceObject(this.Context, Entrys.ToArray(), Entrys.FirstOrDefault().DynamicObjectType, false);
            this.View.UpdateView("F_LQKJ_RuleInfoRuleInformation");
        }
       
       /*public override void BeforeSave(BeforeSaveEventArgs  e)
       {
            if ((DateTime)this.View.Model.GetValue("FTimePeriod") < DateTime.Now.Date)
            {
                this.View.ShowErrMessage("日期不能小于今天！");
                e.Cancel = true;
                return;
            }
            string sql = $"select*from LQKJ_t_AppointmentRules where FTIMEPERIOD='{this.View.Model.GetValue("FTimePeriod")}' and FTYPE='{this.View.Model.GetValue("FType")}'";
            if(DBServiceHelper.ExecuteDataSet(base.Context, sql).Tables[0].Rows.Count > 0)
            {
                this.View.ShowErrMessage("当前当前日期的预约规则已存在！");
                e.Cancel = true;
                return;
            }
        }*/
    }

}
