﻿using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Core.List;
using Kingdee.BOS.Core.List.PlugIn;
using Kingdee.BOS.Orm;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.ServiceHelper;
using Kingdee.BOS.Util;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LQKJ.XiBU.ReportPlugIN
{
    [HotUpdate,Description("列表插件")]
    public class PXItemListReportPlugIn: AbstractListPlugIn
    {
        public override void BarItemClick(BarItemClickEventArgs e)
        {
            var barItemKey = e.BarItemKey;
            base.BarItemClick(e);
            var identity = this.View.Model.OpenParameter.FormId;
            ListSelectedRowCollection listcoll = this.ListView.SelectedRowsInfo;
            List<string> sqlList = new List<string>();
            int result = 0; 
            if (listcoll.Count == 0 && (barItemKey.Equals("LQKJ_ClassIssue")||barItemKey.Equals("LQKJ_Relieve")))
            {
                this.View.ShowMessage("您没有选择任何数据");
                return;
            }
            if(identity== "LQKJ_Course"&&barItemKey== "tbRefresh")
            {
                string sql = "exec CourseCount";
                DBServiceHelper.Execute(base.Context, sql);
                this.View.Refresh();
            }
            switch (barItemKey)
            {
                case "LQKJ_ClassIssue":
                    sqlList = Sql(barItemKey, listcoll);
                    result = DBServiceHelper.ExecuteBatch(this.Context, sqlList);
                    if (result > 0)
                    {
                        this.View.ShowMessage("发布成功！");
                    }
                    break;
                case "LQKJ_Relieve":
                    sqlList = Sql(barItemKey, listcoll);
                    result = DBServiceHelper.ExecuteBatch(this.Context, sqlList);
                    if (result > 0)
                    {
                        this.View.ShowMessage("解绑成功！");
                    }
                    break;
            }
        }
        private List<string> Sql(string barItemKey, ListSelectedRowCollection listcoll)
        {
            List<string> sqlList = new List<string>();
            string uptSql = "";
            for(int i = 0; i < listcoll.Count; i++)
            {
                switch (barItemKey)
                {
                    case "LQKJ_ClassIssue":
                        var entryId = listcoll[i].EntryPrimaryKeyValue;
                        uptSql = $"update T_PX_TRAININGPROINFOENTRY set FISRELEASE='1' where FENTRYID={entryId}";
                        break;
                    case "LQKJ_Relieve":
                        var stuId = listcoll[i].PrimaryKeyValue;
                        uptSql = $"update T_PX_StudentsInfo set FOPENID='' where FSTUDENTID={stuId}";
                        break;
                }
                sqlList.Add(uptSql);
            }
            return sqlList;
        }
        public override void OnInitialize(InitializeEventArgs e)
        {
            base.OnInitialize(e);
            var identity = this.View.Model.OpenParameter.FormId;
            if (identity.Equals("LQKJ_Course"))//课程
            {
                string sql = "exec CourseCount";
                DBServiceHelper.Execute(base.Context, sql);
            }
        }
        public override void EntryButtonCellClick(EntryButtonCellClickEventArgs e)
        {
            base.EntryButtonCellClick(e);
            var identity = this.View.Model.OpenParameter.FormId;
            if(identity== "LQKJ_Course")
            {
                var key = e.FieldKey;
                DynamicObject curRow = this.ListModel.GetData(e.Row - 1, 1, false)[0];
                var param = new ListShowParameter();
                string Filter = "";
                param.FormId = "LQKJ_AttendanceRecord";
                switch (key)
                {
                    case "FRepairCard"://补卡待审批
                        Filter = $"FCOURSEID={curRow["FCOURSEID"]} and (FCOCKINTYPE='QTBQ' OR FCOCKINTYPE='QDBQ') and FDOCUMENTSTATUS!='C' AND FFORBIDSTATUS='A'";
                        break;
                    case "FNormalCheckIn"://正常签到
                        Filter = $"FCOURSEID={curRow["FCOURSEID"]} and FCOCKINTYPE='QD'  and FDOCUMENTSTATUS='C' AND FFORBIDSTATUS='A'";
                        break;
                    case "FRepairCheckIn"://补卡签到
                        Filter = $"FCOURSEID={curRow["FCOURSEID"]} and FCOCKINTYPE='QDBQ'  and FDOCUMENTSTATUS='C' AND FFORBIDSTATUS='A'";
                        break;
                    case "FNormalCheckOut"://正常签退
                        Filter = $"FCOURSEID={curRow["FCOURSEID"]} and FCOCKINTYPE='QT'  and FDOCUMENTSTATUS='C' AND FFORBIDSTATUS='A'";
                        break;
                    case "FRepairCheckOut"://补卡签退
                        Filter = $"FCOURSEID={curRow["FCOURSEID"]} and FCOCKINTYPE='QTBQ'  and FDOCUMENTSTATUS='C' AND FFORBIDSTATUS='A'";
                        break;
                    case "FQDAskForFeave"://签到请假
                        Filter = $"FCOURSEID={curRow["FCOURSEID"]} and FCOCKINTYPE='QDQJ'  and FDOCUMENTSTATUS='C' AND FFORBIDSTATUS='A'";
                        break;
                    case "FQTAskForFeave"://签退请假
                        Filter = $"FCOURSEID={curRow["FCOURSEID"]} and FCOCKINTYPE='QTQJ'  and FDOCUMENTSTATUS='C' AND FFORBIDSTATUS='A'";
                        break;
                    case "FEvaluated"://已评价
                        param.FormId = "LQKJ_Evaluates";
                        Filter = $"FCOURSE={curRow["FCOURSEID"]}   and FDOCUMENTSTATUS='C' AND FFORBIDSTATUS='A'";
                        break;
                }
                if (!String.IsNullOrWhiteSpace(Filter))
                {
                    param.ListFilterParameter.Filter = Filter;
                    this.View.ShowForm(param);
                }
            }
        }
    }
}
