﻿using Kingdee.BOS.Core.DynamicForm.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Log;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.ServiceHelper;
using Kingdee.BOS.Util;
using Kingdee.BOS.WebApi.Client;
using LQKJ.LicVerify;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LQKJ.XiBU.ServicePlugIN
{
    [HotUpdate, Description("服务插件")]
    public class CourseServicePlugIn : AbstractOperationServicePlugIn
    {
        public string dbid = Kingdee.BOS.KDConfiguration.Current.CommonConfiguration.AppSettings.Settings["Dbid"].Value;
        public string username = Kingdee.BOS.KDConfiguration.Current.CommonConfiguration.AppSettings.Settings["username"].Value;
        public string password = Kingdee.BOS.KDConfiguration.Current.CommonConfiguration.AppSettings.Settings["password"].Value;
        public string url = Kingdee.BOS.KDConfiguration.Current.CommonConfiguration.AppSettings.Settings["url"].Value;
        //服务插件
        public override void EndOperationTransaction(EndOperationTransactionArgs e)
        {
            base.EndOperationTransaction(e);
            if (!LicScheduler.LicVerify())
                throw new Exception("lic过期");
            var identity = this.BusinessInfo.GetForm().Id;
            List<string> sqlList = new List<string>();
            string classId = "";
            string uptSql = "";
            switch (identity)
            {
                case "LQKJ_Class"://班级
                    //保存成功后将班级反写到对应课程中
                    var entity = e.DataEntitys[0]["PX_CLASSENTRY"] as DynamicObjectCollection;
                    classId = e.DataEntitys[0]["Id"].ToString();
                    for (int i = 0; i < entity.Count; i++)
                    {
                        var courseId = entity[i]["FCourseId_Id"];//课程Id
                        uptSql = $"update T_PX_COURSE set FCLASSID={classId} where FCOURSEID={courseId}";
                        sqlList.Add(uptSql);
                        DBServiceHelper.ExecuteBatch(this.Context, sqlList);
                    }
                    break;
                case "LQKJ_ClassDetails"://班级学员通讯录
                    var count = e.DataEntitys[0]["PX_ADDRESSBOOKENTRY"] as DynamicObjectCollection;
                    classId = e.DataEntitys[0]["Class_Id"].ToString();
                    uptSql = $"update T_PX_CLASS set FCONFIRMQTY={count.Count} where FCLASSID={classId}";
                    sqlList.Add(uptSql);
                    DBServiceHelper.ExecuteBatch(this.Context, sqlList);
                    break;

                //case "LQKJ_AttendanceRecord"://考勤
                //case "LQKJ_Evaluates"://评价
                //        var Id = e.DataEntitys[0]["Id"].ToString();
                //        K3CloudApiClient Client = new K3CloudApiClient(url);
                //        var loginResult = Client.ValidateLogin(dbid, username, password, 2052);
                //        var resultType = JObject.Parse(loginResult)["LoginResultType"].Value<int>();
                //        if (resultType == 1)//登录成功
                //        {
                //            Client.Submit(identity, "{\"Ids\":" + Id + "}");
                //            Client.Audit(identity, "{\"Ids\":" + Id + "}");
                //        }
                //    break;
            }
        }
    }
}
